/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.android;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.MapOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.android.AndroidDevicePayload;
import com.urbanairship.api.push.model.notification.android.Category;
import com.urbanairship.api.push.model.notification.android.PublicNotification;
import com.urbanairship.api.push.model.notification.android.Style;
import com.urbanairship.api.push.model.notification.android.Wearable;
import java.io.IOException;

public class AndroidDevicePayloadReader
implements JsonObjectReader<AndroidDevicePayload> {
    private final AndroidDevicePayload.Builder builder = AndroidDevicePayload.newBuilder();

    public void readAlert(JsonParser parser) throws IOException {
        this.builder.setAlert(StringFieldDeserializer.INSTANCE.deserialize(parser, "alert"));
    }

    public void readCollapseKey(JsonParser parser) throws IOException {
        this.builder.setCollapseKey(StringFieldDeserializer.INSTANCE.deserialize(parser, "collapse_key"));
    }

    public void readNotificationChannel(JsonParser parser) throws IOException {
        this.builder.setNotificationChannel(StringFieldDeserializer.INSTANCE.deserialize(parser, "notification_channel"));
    }

    public void readNotificationTag(JsonParser parser) throws IOException {
        this.builder.setNotificationTag(StringFieldDeserializer.INSTANCE.deserialize(parser, "notification_tag"));
    }

    public void readTimeToLive(JsonParser parser) throws IOException {
        this.builder.setTimeToLive((PushExpiry)parser.readValueAs(PushExpiry.class));
    }

    public void readDeliveryPriority(JsonParser parser) throws IOException {
        this.builder.setDeliveryPriority((String)parser.readValueAs(String.class));
    }

    public void readDelayWhileIdle(JsonParser parser) throws IOException {
        this.builder.setDelayWhileIdle(BooleanFieldDeserializer.INSTANCE.deserialize(parser, "delay_while_idle"));
    }

    public void readExtra(JsonParser parser) throws IOException {
        this.builder.addAllExtraEntries(MapOfStringsDeserializer.INSTANCE.deserialize(parser, "extra"));
    }

    public void readInteractive(JsonParser parser) throws IOException {
        this.builder.setInteractive((Interactive)parser.readValueAs(Interactive.class));
    }

    public void readTitle(JsonParser parser) throws IOException {
        this.builder.setTitle(StringFieldDeserializer.INSTANCE.deserialize(parser, "title"));
    }

    public void readWearable(JsonParser parser) throws IOException {
        this.builder.setWearable((Wearable)parser.readValueAs(Wearable.class));
    }

    public void readLocalOnly(JsonParser parser) throws IOException {
        this.builder.setLocalOnly((Boolean)parser.readValueAs(Boolean.class));
    }

    public void readSummary(JsonParser parser) throws IOException {
        this.builder.setSummary((String)parser.readValueAs(String.class));
    }

    public void readStyle(JsonParser parser) throws IOException {
        this.builder.setStyle((Style)parser.readValueAs(Style.class));
    }

    public void readSound(JsonParser parser) throws IOException {
        this.builder.setSound((String)parser.readValueAs(String.class));
    }

    public void readIcon(JsonParser parser) throws IOException {
        this.builder.setIcon((String)parser.readValueAs(String.class));
    }

    public void readIconColor(JsonParser parser) throws IOException {
        this.builder.setIconColor(StringFieldDeserializer.INSTANCE.deserialize(parser, "icon_color"));
    }

    public void readPriority(JsonParser parser) throws IOException {
        this.builder.setPriority((Integer)parser.readValueAs(Integer.class));
    }

    public void readCategory(JsonParser parser) throws IOException {
        this.builder.setCategory((Category)((Object)parser.readValueAs(Category.class)));
    }

    public void readVisibility(JsonParser parser) throws IOException {
        this.builder.setVisibility((Integer)parser.readValueAs(Integer.class));
    }

    public void readPublicNotification(JsonParser parser) throws IOException {
        this.builder.setPublicNotification((PublicNotification)parser.readValueAs(PublicNotification.class));
    }

    @Override
    public AndroidDevicePayload validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }
}

