/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.Precision;
import com.urbanairship.api.reports.model.ResponseReport;
import com.urbanairship.api.reports.parse.ReportsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ResponseReportRequest
implements Request<ResponseReport> {
    private static final String API_RESPONSE_REPORT = "/api/reports/responses/";
    private final String path;
    private final boolean nextPageRequest;
    private DateTime start;
    private DateTime end;
    private Precision precision;

    private ResponseReportRequest(DateTime start, DateTime end, Precision precision, String path, boolean nextPageRequest) {
        this.path = path;
        this.nextPageRequest = nextPageRequest;
        this.start = start;
        this.end = end;
        this.precision = precision;
    }

    public static ResponseReportRequest newRequest(DateTime start, DateTime end, Precision precision) {
        return new ResponseReportRequest(start, end, precision, API_RESPONSE_REPORT, false);
    }

    public static ResponseReportRequest newRequest(DateTime start, DateTime end, Precision precision, URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI cannot be null");
        return new ResponseReportRequest(start, end, precision, nextPage.getPath() + "?" + nextPage.getQuery(), true);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        URI uri;
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        if (!this.nextPageRequest) {
            Preconditions.checkNotNull((Object)this.start, (Object)"start cannot be null");
            Preconditions.checkNotNull((Object)this.end, (Object)"end cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.precision), (Object)"precision cannot be null");
            Preconditions.checkArgument((boolean)this.end.isAfter((ReadableInstant)this.start), (Object)"end date must occur after start date");
            builder.addParameter("start", this.start.toString(DateFormats.DATE_FORMATTER));
            builder.addParameter("end", this.end.toString(DateFormats.DATE_FORMATTER));
            builder.addParameter("precision", this.precision.toString());
        }
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    @Override
    public ResponseParser<ResponseReport> getResponseParser() {
        return new ResponseParser<ResponseReport>(){

            @Override
            public ResponseReport parse(String response) throws IOException {
                return (ResponseReport)ReportsObjectMapper.getInstance().readValue(response, ResponseReport.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

