/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.schedule.model.ScheduleModelObject;
import com.urbanairship.api.schedule.model.SchedulePayload;

public final class ScheduleDetails
extends ScheduleModelObject {
    private final String jobId;
    private final SchedulePayload schedulePayload;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ScheduleDetails(String jobId, SchedulePayload schedulePayload) {
        this.schedulePayload = schedulePayload;
        this.jobId = jobId;
    }

    public SchedulePayload getSchedulePayload() {
        return this.schedulePayload;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String toString() {
        return "ScheduleDetails{jobId='" + this.jobId + '\'' + ", schedulePayload=" + this.schedulePayload + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.jobId, this.schedulePayload});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleDetails other = (ScheduleDetails)obj;
        return Objects.equal((Object)this.jobId, (Object)other.jobId) && Objects.equal((Object)this.schedulePayload, (Object)other.schedulePayload);
    }

    public static final class Builder {
        private String jobId = null;
        private SchedulePayload schedulePayload = null;

        private Builder() {
        }

        public Builder setSchedulePayload(SchedulePayload schedulePayload) {
            this.schedulePayload = schedulePayload;
            return this;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public ScheduleDetails build() {
            Preconditions.checkNotNull((Object)this.schedulePayload, (Object)"schedule payload must be provided");
            Preconditions.checkNotNull((Object)this.jobId, (Object)"job id must be provided");
            return new ScheduleDetails(this.jobId, this.schedulePayload);
        }
    }
}

