/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.PushOptions;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.model.notification.richpush.RichPushMessage;

public class PartialPushPayload {
    private final Optional<Notification> notification;
    private final Optional<PushOptions> pushOptions;
    private final Optional<RichPushMessage> richPushMessage;
    private final Optional<InApp> inApp;

    private PartialPushPayload(Builder builder) {
        this.notification = Optional.fromNullable((Object)builder.notification);
        this.pushOptions = Optional.fromNullable((Object)builder.pushOptions);
        this.richPushMessage = Optional.fromNullable((Object)builder.richPushMessage);
        this.inApp = Optional.fromNullable((Object)builder.inApp);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Notification> getNotification() {
        return this.notification;
    }

    public Optional<PushOptions> getPushOptions() {
        return this.pushOptions;
    }

    public Optional<RichPushMessage> getRichPushMessage() {
        return this.richPushMessage;
    }

    public Optional<InApp> getInApp() {
        return this.inApp;
    }

    public String toString() {
        return "PartialPushPayload{notification=" + this.notification + ", pushOptions=" + this.pushOptions + ", richPushMessage=" + this.richPushMessage + ", inApp=" + this.inApp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialPushPayload that = (PartialPushPayload)o;
        if (!this.inApp.equals(that.inApp)) {
            return false;
        }
        if (!this.notification.equals(that.notification)) {
            return false;
        }
        if (!this.pushOptions.equals(that.pushOptions)) {
            return false;
        }
        return this.richPushMessage.equals(that.richPushMessage);
    }

    public int hashCode() {
        int result = this.notification.hashCode();
        result = 31 * result + this.pushOptions.hashCode();
        result = 31 * result + this.richPushMessage.hashCode();
        result = 31 * result + this.inApp.hashCode();
        return result;
    }

    public static class Builder {
        private Notification notification = null;
        private PushOptions pushOptions = null;
        private RichPushMessage richPushMessage = null;
        private InApp inApp = null;

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setPushOptions(PushOptions pushOptions) {
            this.pushOptions = pushOptions;
            return this;
        }

        public Builder setRichPushMessage(RichPushMessage richPushMessage) {
            this.richPushMessage = richPushMessage;
            return this;
        }

        public Builder setInApp(InApp inApp) {
            this.inApp = inApp;
            return this;
        }

        public PartialPushPayload build() {
            Preconditions.checkArgument((this.notification != null || this.richPushMessage != null || this.inApp != null ? 1 : 0) != 0, (Object)"At least one of 'notification', 'richPushMessage', or 'inApp' must be set.");
            return new PartialPushPayload(this);
        }
    }
}

