/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.templates.model;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.templates.model.TemplateSelector;

public class TemplatePushPayload {
    private final Selector audience;
    private final DeviceTypeData deviceTypes;
    private final TemplateSelector mergeData;

    private TemplatePushPayload(Builder builder) {
        this.audience = builder.audience;
        this.deviceTypes = builder.deviceTypes;
        this.mergeData = builder.mergeData;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Selector getAudience() {
        return this.audience;
    }

    public DeviceTypeData getDeviceTypes() {
        return this.deviceTypes;
    }

    public TemplateSelector getMergeData() {
        return this.mergeData;
    }

    public String toString() {
        return "TemplatePushPayload{audience=" + this.audience + ", deviceTypes=" + this.deviceTypes + ", mergeData=" + this.mergeData + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplatePushPayload that = (TemplatePushPayload)o;
        if (!this.audience.equals(that.audience)) {
            return false;
        }
        if (!this.deviceTypes.equals(that.deviceTypes)) {
            return false;
        }
        return this.mergeData.equals(that.mergeData);
    }

    public int hashCode() {
        int result = this.audience.hashCode();
        result = 31 * result + this.deviceTypes.hashCode();
        result = 31 * result + this.mergeData.hashCode();
        return result;
    }

    public static class Builder {
        private Selector audience = null;
        private DeviceTypeData deviceTypes = null;
        private TemplateSelector mergeData = null;

        public Builder setAudience(Selector audience) {
            this.audience = audience;
            return this;
        }

        public Builder setDeviceTypes(DeviceTypeData deviceTypes) {
            this.deviceTypes = deviceTypes;
            return this;
        }

        public Builder setMergeData(TemplateSelector mergeData) {
            this.mergeData = mergeData;
            return this;
        }

        public TemplatePushPayload build() {
            Preconditions.checkArgument((this.audience != null && this.deviceTypes != null && this.mergeData != null ? 1 : 0) != 0, (Object)"audience, deviceTypes, and mergeData cannot be null.");
            return new TemplatePushPayload(this);
        }
    }
}

