/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.audience.sms;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;

public final class SmsChannel {
    private final String msisdn;
    private final DateTime optedIn;
    private final String sender;
    private final Optional<ImmutableMap<String, String>> substitutions;

    private SmsChannel(Builder builder) {
        this.msisdn = builder.msisdn;
        this.optedIn = builder.optedIn;
        this.sender = builder.sender;
        this.substitutions = builder.substitutions.build().isEmpty() ? Optional.empty() : Optional.of(builder.substitutions.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public DateTime getOptedIn() {
        return this.optedIn;
    }

    public String getSender() {
        return this.sender;
    }

    public Optional<ImmutableMap<String, String>> getSubstitutions() {
        return this.substitutions;
    }

    public String toString() {
        return "SmsChannel{msisdn='" + this.msisdn + '\'' + ", optedIn='" + this.optedIn + '\'' + ", sender='" + this.sender + '\'' + ", substitutions=" + this.substitutions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsChannel that = (SmsChannel)o;
        return Objects.equal((Object)this.msisdn, (Object)that.msisdn) && Objects.equal((Object)this.optedIn, (Object)that.optedIn) && Objects.equal((Object)this.sender, (Object)that.sender) && Objects.equal(this.substitutions, that.substitutions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.msisdn, this.optedIn, this.sender, this.substitutions});
    }

    public static final class Builder {
        private String msisdn;
        private DateTime optedIn;
        private String sender;
        private ImmutableMap.Builder<String, String> substitutions = ImmutableMap.builder();

        public Builder setMsisdn(String msisdn) {
            this.msisdn = msisdn;
            return this;
        }

        public Builder setOptedIn(DateTime optedIn) {
            this.optedIn = optedIn;
            return this;
        }

        public Builder setSender(String sender) {
            this.sender = sender;
            return this;
        }

        public Builder addSubstitution(String key, String value) {
            this.substitutions.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllSubstitutions(Map<String, String> substitutions) {
            this.substitutions.putAll(substitutions);
            return this;
        }

        public SmsChannel build() {
            Preconditions.checkNotNull((Object)this.msisdn, (Object)"msisdn cannot be null.");
            Preconditions.checkNotNull((Object)this.optedIn, (Object)"optedIn must not be null.");
            Preconditions.checkNotNull((Object)this.sender, (Object)"sender must not be null.");
            return new SmsChannel(this);
        }
    }
}

