/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports;

import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.reports.model.DevicesReport;
import com.urbanairship.api.reports.parse.ReportsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;

public class DevicesReportRequest
implements Request<DevicesReport> {
    private static final String API_DEVICES_REPORT = "/api/reports/devices/";
    private final String path;
    private Optional<DateTime> date;

    private DevicesReportRequest(String path) {
        this.path = path;
        this.date = Optional.empty();
    }

    public static DevicesReportRequest newRequest() {
        return new DevicesReportRequest(API_DEVICES_REPORT);
    }

    public DevicesReportRequest setDate(DateTime date) {
        this.date = Optional.of(date);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        URI uri;
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, this.path));
        if (this.date.isPresent()) {
            builder.addParameter("date", this.date.get().toString(DateFormats.DATE_FORMATTER));
        }
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    @Override
    public ResponseParser<DevicesReport> getResponseParser() {
        return new ResponseParser<DevicesReport>(){

            @Override
            public DevicesReport parse(String response) throws IOException {
                return (DevicesReport)ReportsObjectMapper.getInstance().readValue(response, DevicesReport.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

