/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.collect.ImmutableList;
import com.urbanairship.api.reports.model.DevicesReportResponse;
import java.util.Objects;
import java.util.Optional;

public class DevicesReport {
    private final Optional<String> dateClosed;
    private final Optional<String> dateComputed;
    private final Optional<Integer> totalUniqueDevices;
    private final Optional<ImmutableList<DevicesReportResponse>> counts;

    private DevicesReport(Builder builder) {
        this.dateClosed = Optional.ofNullable(builder.dateClosed);
        this.dateComputed = Optional.ofNullable(builder.dateComputed);
        this.totalUniqueDevices = Optional.ofNullable(builder.totalUniqueDevices);
        this.counts = Optional.ofNullable(builder.counts.build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getDateClosed() {
        return this.dateClosed;
    }

    public Optional<String> getDateComputed() {
        return this.dateComputed;
    }

    public Optional<Integer> getTotalUniqueDevices() {
        return this.totalUniqueDevices;
    }

    public Optional<ImmutableList<DevicesReportResponse>> getCounts() {
        return this.counts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DevicesReport)) {
            return false;
        }
        DevicesReport that = (DevicesReport)o;
        return Objects.equals(this.dateClosed, that.dateClosed) && Objects.equals(this.dateComputed, that.dateComputed) && Objects.equals(this.totalUniqueDevices, that.totalUniqueDevices) && Objects.equals(this.getCounts(), that.getCounts());
    }

    public int hashCode() {
        return Objects.hash(this.dateClosed, this.dateComputed, this.totalUniqueDevices, this.getCounts());
    }

    public String toString() {
        return "DevicesReport{dateClosed=" + this.dateClosed + ", dateComputed=" + this.dateComputed + ", totalUniqueDevices=" + this.totalUniqueDevices + ", counts=" + this.counts + '}';
    }

    public static class Builder {
        private String dateClosed;
        private String dateComputed;
        private Integer totalUniqueDevices;
        private ImmutableList.Builder<DevicesReportResponse> counts = ImmutableList.builder();

        private Builder() {
        }

        public Builder setDateClosed(String dateClosed) {
            this.dateClosed = dateClosed;
            return this;
        }

        public Builder setDateComputed(String dateComputed) {
            this.dateComputed = dateComputed;
            return this;
        }

        public Builder setTotalUniqueDevices(Integer totalUniqueDevices) {
            this.totalUniqueDevices = totalUniqueDevices;
            return this;
        }

        public Builder addDevicesReportResponseObject(DevicesReportResponse object) {
            this.counts.add((Object)object);
            return this;
        }

        public DevicesReport build() {
            return new DevicesReport(this);
        }
    }
}

