/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.open;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.channel.model.ChannelType;
import com.urbanairship.api.channel.model.open.OpenChannel;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.List;

public class Channel
extends PushModelObject {
    private final ChannelType type;
    private final Optional<Boolean> optIn;
    private final Optional<String> address;
    private final Optional<Boolean> setTags;
    private final Optional<ImmutableList<String>> tags;
    private final Optional<String> timezone;
    private final Optional<String> localeCountry;
    private final Optional<String> localeLanguage;
    private final OpenChannel open;

    private Channel(Builder builder) {
        this.type = builder.type;
        this.open = builder.open;
        this.address = Optional.fromNullable((Object)builder.address);
        this.optIn = Optional.fromNullable((Object)builder.optIn);
        this.setTags = Optional.fromNullable((Object)builder.setTags);
        this.timezone = Optional.fromNullable((Object)builder.timezone);
        this.localeCountry = Optional.fromNullable((Object)builder.locale_country);
        this.localeLanguage = Optional.fromNullable((Object)builder.locale_language);
        this.tags = builder.tags.build().isEmpty() ? Optional.absent() : Optional.of((Object)builder.tags.build());
    }

    public ChannelType getType() {
        return this.type;
    }

    public Optional<Boolean> getOptIn() {
        return this.optIn;
    }

    public Optional<String> getAddress() {
        return this.address;
    }

    public Optional<Boolean> getSetTags() {
        return this.setTags;
    }

    public Optional<ImmutableList<String>> getTags() {
        return this.tags;
    }

    public Optional<String> getTimezone() {
        return this.timezone;
    }

    public Optional<String> getLocaleCountry() {
        return this.localeCountry;
    }

    public Optional<String> getLocaleLanguage() {
        return this.localeLanguage;
    }

    public OpenChannel getOpen() {
        return this.open;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel that = (Channel)o;
        return this.type == that.type && Objects.equal(this.optIn, that.optIn) && Objects.equal(this.address, that.address) && Objects.equal(this.setTags, that.setTags) && Objects.equal(this.tags, that.tags) && Objects.equal(this.timezone, that.timezone) && Objects.equal(this.localeCountry, that.localeCountry) && Objects.equal(this.localeLanguage, that.localeLanguage) && Objects.equal((Object)this.open, (Object)that.open);
    }

    public String toString() {
        return "Channel{type=" + (Object)((Object)this.type) + ", optIn=" + this.optIn + ", address=" + this.address + ", setTags=" + this.setTags + ", tags=" + this.tags + ", timezone=" + this.timezone + ", localeCountry=" + this.localeCountry + ", localeLanguage=" + this.localeLanguage + ", open=" + this.open + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.optIn, this.address, this.setTags, this.tags, this.timezone, this.localeCountry, this.localeLanguage, this.open});
    }

    public static final class Builder {
        private ChannelType type;
        private boolean optIn;
        private String address;
        private boolean setTags;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        private String timezone;
        private String locale_country;
        private String locale_language;
        private OpenChannel open;

        private Builder() {
        }

        public Builder setChannelType(ChannelType type) {
            this.type = type;
            return this;
        }

        public Builder setOptIn(boolean optIn) {
            this.optIn = optIn;
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setTags(boolean setTags) {
            this.setTags = setTags;
            return this;
        }

        public Builder addAllTags(List<String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add((Object)tag);
            return this;
        }

        public Builder setTimeZone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder setLocaleCountry(String locale_country) {
            this.locale_country = locale_country;
            return this;
        }

        public Builder setLocaleLanguage(String locale_language) {
            this.locale_language = locale_language;
            return this;
        }

        public Builder setOpenChannel(OpenChannel open) {
            this.open = open;
            return this;
        }

        public Channel build() {
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"'type' cannot be null.");
            Preconditions.checkNotNull((Object)this.open, (Object)"'open' cannot be null.");
            return new Channel(this);
        }
    }
}

