/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.audience.email;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.joda.time.DateTime;

public class EmailChannel {
    private final Optional<DateTime> commercialOptedIn;
    private final Optional<DateTime> transactionalOptedIn;
    private final String uaAddress;
    private final Optional<Map<String, String>> substitutions;

    private EmailChannel(Builder builder) {
        this.uaAddress = builder.uaAddress;
        this.commercialOptedIn = Optional.fromNullable((Object)builder.commercialOptedIn);
        this.transactionalOptedIn = Optional.fromNullable((Object)builder.transactionalOptedIn);
        this.substitutions = !builder.substitutions.build().isEmpty() ? Optional.fromNullable((Object)builder.substitutions.build()) : Optional.absent();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<DateTime> getCommercialOptedIn() {
        return this.commercialOptedIn;
    }

    public Optional<DateTime> getTransactionalOptedIn() {
        return this.transactionalOptedIn;
    }

    public String getUaAddress() {
        return this.uaAddress;
    }

    public Optional<Map<String, String>> getSubstitutions() {
        return this.substitutions;
    }

    public static final class Builder {
        private String uaAddress;
        private DateTime commercialOptedIn;
        private DateTime transactionalOptedIn;
        private ImmutableMap.Builder<String, String> substitutions = ImmutableMap.builder();

        public Builder setAddress(String address) {
            this.uaAddress = address;
            return this;
        }

        public Builder setCommertialOptedIn(DateTime commercialOptedInDate) {
            this.commercialOptedIn = commercialOptedInDate;
            return this;
        }

        public Builder setTransactionalOptedIn(DateTime transactionalOptedInDate) {
            this.transactionalOptedIn = transactionalOptedInDate;
            return this;
        }

        public Builder addSubstitution(String key, String value) {
            this.substitutions.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllSubstitutions(Map<String, String> substitutions) {
            this.substitutions.putAll(substitutions);
            return this;
        }

        public EmailChannel build() {
            Preconditions.checkNotNull((Object)this.uaAddress, (Object)"uaAddress cannot be null.");
            return new EmailChannel(this);
        }
    }
}

