/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import java.util.Objects;
import java.util.Optional;

public final class DeviceStats {
    private final Optional<Integer> direct;
    private final Optional<Integer> influenced;

    private DeviceStats(Optional<Integer> direct, Optional<Integer> influenced) {
        this.direct = direct;
        this.influenced = influenced;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceStats that = (DeviceStats)o;
        return Objects.equals(this.direct, that.direct) && Objects.equals(this.influenced, that.influenced);
    }

    public int hashCode() {
        return Objects.hash(this.direct, this.influenced);
    }

    public String toString() {
        return "DeviceStats{direct=" + this.direct + ", influenced=" + this.influenced + '}';
    }

    public Optional<Integer> getDirect() {
        return this.direct;
    }

    public Optional<Integer> getInfluenced() {
        return this.influenced;
    }

    public static class Builder {
        private int direct;
        private int influenced;

        private Builder() {
        }

        public Builder setDirect(int value) {
            this.direct = value;
            return this;
        }

        public Builder setInfluenced(int value) {
            this.influenced = value;
            return this;
        }

        public DeviceStats build() {
            return new DeviceStats(Optional.ofNullable(this.direct), Optional.ofNullable(this.influenced));
        }
    }
}

