/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.collect.ImmutableList;
import com.urbanairship.api.reports.model.ResponseReportResponse;
import java.util.Objects;
import java.util.Optional;

public class ResponseReport {
    private final Optional<String> next_page;
    private final Optional<ImmutableList<ResponseReportResponse>> responses;

    private ResponseReport(Optional<String> next_page, Optional<ImmutableList<ResponseReportResponse>> responses) {
        this.next_page = next_page;
        this.responses = responses;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getNextPage() {
        return this.next_page;
    }

    public Optional<ImmutableList<ResponseReportResponse>> getResponses() {
        return this.responses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseReport that = (ResponseReport)o;
        return Objects.equals(this.next_page, that.next_page) && Objects.equals(this.responses, that.responses);
    }

    public int hashCode() {
        return Objects.hash(this.next_page, this.responses);
    }

    public String toString() {
        return "ResponseReport{next_page=" + this.next_page + ", responses=" + this.responses + '}';
    }

    public static class Builder {
        private String next_page = null;
        private ImmutableList.Builder<ResponseReportResponse> responses = ImmutableList.builder();

        private Builder() {
        }

        public Builder setNextPage(String next_page) {
            this.next_page = next_page;
            return this;
        }

        public Builder addResponseObject(ResponseReportResponse object) {
            this.responses.add((Object)object);
            return this;
        }

        public Builder addResponseObject(Iterable<? extends ResponseReportResponse> object) {
            this.responses.addAll(object);
            return this;
        }

        public ResponseReport build() {
            return new ResponseReport(Optional.ofNullable(this.next_page), Optional.ofNullable(this.responses.build()));
        }
    }
}

