/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.schedule.ListSchedulesOrderType;
import com.urbanairship.api.schedule.model.ListAllSchedulesResponse;
import com.urbanairship.api.schedule.model.SchedulePayloadResponse;
import com.urbanairship.api.schedule.parse.ScheduleObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class ScheduleListingRequest
implements Request<ListAllSchedulesResponse> {
    private static final ResponseParser<ListAllSchedulesResponse> LIST_PARSER = new ResponseParser<ListAllSchedulesResponse>(){

        @Override
        public ListAllSchedulesResponse parse(String response) throws IOException {
            return (ListAllSchedulesResponse)ScheduleObjectMapper.getInstance().readValue(response, ListAllSchedulesResponse.class);
        }
    };
    private static final ResponseParser<ListAllSchedulesResponse> SINGLE_LOOKUP_PARSER = new ResponseParser<ListAllSchedulesResponse>(){

        @Override
        public ListAllSchedulesResponse parse(String response) throws IOException {
            return ListAllSchedulesResponse.newBuilder().setCount(1).setTotalCount(1).setOk(true).addSchedule((SchedulePayloadResponse)ScheduleObjectMapper.getInstance().readValue(response, SchedulePayloadResponse.class)).build();
        }
    };
    private final String path;
    private final ResponseParser<ListAllSchedulesResponse> parser;

    private ScheduleListingRequest(String path, ResponseParser<ListAllSchedulesResponse> parser) {
        this.path = path;
        this.parser = parser;
    }

    public static ScheduleListingRequest newRequest() {
        return new ScheduleListingRequest("/api/schedules/", LIST_PARSER);
    }

    public static ScheduleListingRequest newRequest(String scheduleId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"Schedule ID may not be null");
        return new ScheduleListingRequest("/api/schedules/" + scheduleId, SINGLE_LOOKUP_PARSER);
    }

    public static ScheduleListingRequest newRequest(UUID start, int limit, ListSchedulesOrderType orderType) {
        Preconditions.checkNotNull((Object)start, (Object)"Start ID may not be null");
        Preconditions.checkNotNull((Object)((Object)orderType), (Object)"Listing response order option may not be null");
        String path = "/api/schedules/?start=" + start.toString() + "&limit=" + limit + "&order=" + orderType.getKey();
        return new ScheduleListingRequest(path, LIST_PARSER);
    }

    public static ScheduleListingRequest newRequest(URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI may not be null");
        return new ScheduleListingRequest(nextPage.getPath() + "?" + nextPage.getQuery(), LIST_PARSER);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<ListAllSchedulesResponse> getResponseParser() {
        return this.parser;
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

