/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.ChannelResponse;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ChannelRequest
implements Request<ChannelResponse> {
    private static final String API_CHANNELS_LIST = "/api/channels/";
    private static final String API_SMS_CHANNEL = "/api/channels/sms/";
    private final String path;

    private ChannelRequest(String path) {
        this.path = path;
    }

    public static ChannelRequest newRequest(String channel) {
        return new ChannelRequest(API_CHANNELS_LIST + channel);
    }

    public static ChannelRequest newRequest() {
        return new ChannelRequest(API_CHANNELS_LIST);
    }

    public static ChannelRequest newRequest(URI nextPage) {
        Preconditions.checkNotNull((Object)nextPage, (Object)"Next page URI cannot be null");
        return new ChannelRequest(nextPage.getPath() + "?" + nextPage.getQuery());
    }

    public static ChannelRequest newSmsLookupRequest(String msisdn, String sender) {
        Preconditions.checkNotNull((Object)msisdn, (Object)"msisdn cannot be null.");
        Preconditions.checkNotNull((Object)sender, (Object)"Sender cannot be null.");
        return new ChannelRequest(API_SMS_CHANNEL + msisdn + "/" + sender);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<ChannelResponse> getResponseParser() {
        return new ResponseParser<ChannelResponse>(){

            @Override
            public ChannelResponse parse(String response) throws IOException {
                return (ChannelResponse)ChannelObjectMapper.getInstance().readValue(response, ChannelResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }
}

