/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.entity.ContentType;

public class ChannelTagRequest
implements Request<String> {
    private static final String API_CHANNELS_TAGS_PATH = "/api/channels/tags/";
    private static final String IOS_CHANNEL_KEY = "ios_channel";
    private static final String ANDROID_CHANNEL_KEY = "android_channel";
    private static final String AMAZON_CHANNEL_KEY = "amazon_channel";
    private static final String GENERIC_CHANNEL_KEY = "channel";
    private static final String AUDIENCE_KEY = "audience";
    private static final String ADD_KEY = "add";
    private static final String REMOVE_KEY = "remove";
    private static final String SET_KEY = "set";
    private final Map<String, Set<String>> audience = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> addTags = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> removeTags = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> setTags = new HashMap<String, Set<String>>();

    public static ChannelTagRequest newRequest() {
        return new ChannelTagRequest();
    }

    public ChannelTagRequest addIOSChannel(String channel) {
        return this.addIOSChannels(channel);
    }

    public ChannelTagRequest addIOSChannels(String ... channels) {
        return this.addIOSChannels(new HashSet<String>(Arrays.asList(channels)));
    }

    public ChannelTagRequest addIOSChannels(Set<String> channels) {
        ChannelTagRequest.appendMapValues(IOS_CHANNEL_KEY, channels, this.audience);
        return this;
    }

    public ChannelTagRequest addAndroidChannel(String channel) {
        return this.addAndroidChannels(channel);
    }

    public ChannelTagRequest addAndroidChannels(String ... channels) {
        return this.addAndroidChannels(new HashSet<String>(Arrays.asList(channels)));
    }

    public ChannelTagRequest addAndroidChannels(Set<String> channels) {
        ChannelTagRequest.appendMapValues(ANDROID_CHANNEL_KEY, channels, this.audience);
        return this;
    }

    public ChannelTagRequest addAmazonChannel(String channel) {
        return this.addAmazonChannels(channel);
    }

    public ChannelTagRequest addAmazonChannels(String ... channels) {
        return this.addAmazonChannels(new HashSet<String>(Arrays.asList(channels)));
    }

    public ChannelTagRequest addAmazonChannels(Set<String> channels) {
        ChannelTagRequest.appendMapValues(AMAZON_CHANNEL_KEY, channels, this.audience);
        return this;
    }

    public ChannelTagRequest addGenericChannel(String channel) {
        return this.addGenericChannels(channel);
    }

    public ChannelTagRequest addGenericChannels(String ... channels) {
        return this.addGenericChannels(new HashSet<String>(Arrays.asList(channels)));
    }

    public ChannelTagRequest addGenericChannels(Set<String> channels) {
        ChannelTagRequest.appendMapValues(GENERIC_CHANNEL_KEY, channels, this.audience);
        return this;
    }

    public ChannelTagRequest addTags(String tagGroup, Set<String> tags) {
        ChannelTagRequest.appendMapValues(tagGroup, tags, this.addTags);
        return this;
    }

    public ChannelTagRequest removeTags(String tagGroup, Set<String> tags) {
        ChannelTagRequest.appendMapValues(tagGroup, tags, this.removeTags);
        return this;
    }

    public ChannelTagRequest setTags(String tagGroup, Set<String> tags) {
        ChannelTagRequest.appendMapValues(tagGroup, tags, this.setTags);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        HashMap<String, Map<String, Set<String>>> payload = new HashMap<String, Map<String, Set<String>>>();
        payload.put(AUDIENCE_KEY, this.audience);
        if (!this.addTags.isEmpty()) {
            payload.put(ADD_KEY, this.addTags);
        }
        if (!this.removeTags.isEmpty()) {
            payload.put(REMOVE_KEY, this.removeTags);
        }
        if (!this.setTags.isEmpty()) {
            payload.put(SET_KEY, this.setTags);
        }
        Preconditions.checkArgument((boolean)payload.containsKey(AUDIENCE_KEY), (Object)"Audience required when executing a channel tag operation");
        Preconditions.checkArgument((payload.containsKey(ADD_KEY) || payload.containsKey(REMOVE_KEY) || payload.containsKey(SET_KEY) ? 1 : 0) != 0, (Object)"Audience required when executing a channel tag operation");
        if (payload.containsKey(SET_KEY)) {
            Preconditions.checkArgument((!payload.containsKey(REMOVE_KEY) && !payload.containsKey(ADD_KEY) ? 1 : 0) != 0);
        }
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString(payload);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, API_CHANNELS_TAGS_PATH);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    private static void appendMapValues(String key, Set<String> values, Map<String, Set<String>> map) {
        if (!map.containsKey(key)) {
            map.put(key, values);
        } else {
            Set<String> newSet = map.get(key);
            newSet.addAll(values);
            map.put(key, newSet);
        }
    }
}

