/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.urbanairship.api.client.AsyncRequestClient;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestClient;
import com.urbanairship.api.client.Response;
import com.urbanairship.api.client.ResponseCallback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrbanAirshipClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(UrbanAirshipClient.class);
    private final RequestClient client;
    private final String key;
    private final Optional<String> secret;
    private final Optional<String> bearerToken;
    private String userAgent;
    public static final String EU_URI = "https://go.airship.eu";

    private UrbanAirshipClient(Builder builder) {
        this.client = builder.client;
        this.userAgent = this.getUserAgent();
        this.key = builder.key;
        this.secret = Optional.fromNullable((Object)builder.secret);
        this.bearerToken = Optional.fromNullable((Object)builder.bearerToken);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public <T> Future<Response> executeAsync(Request<T> request, ResponseCallback callback) {
        return this.client.executeAsync(request, callback, this.createHeaders(request));
    }

    public <T> Future<Response> executeAsync(Request<T> request) {
        return this.executeAsync(request, null);
    }

    public <T> Response execute(Request<T> request) throws IOException {
        return this.execute(request, null);
    }

    public <T> Response execute(Request<T> request, ResponseCallback callback) throws IOException {
        try {
            return this.executeAsync(request, callback).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while retrieving response from future", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to retrieve response from future", e);
        }
    }

    private Map<String, String> createHeaders(Request request) {
        String auth;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", this.userAgent);
        Map<String, String> requestHeaders = request.getRequestHeaders();
        if (requestHeaders != null) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        if (request.bearerTokenAuthRequired()) {
            Preconditions.checkArgument((boolean)this.bearerToken.isPresent(), (Object)("Bearer token required for request: " + request));
            auth = "Bearer " + (String)this.getBearerToken().get();
        } else {
            Preconditions.checkArgument((boolean)this.getAppSecret().isPresent(), (Object)("App secret required for request: " + request));
            auth = "Basic " + BaseEncoding.base64().encode((this.getAppKey() + ":" + (String)this.getAppSecret().get()).getBytes());
        }
        headers.put("Authorization", auth);
        headers.put("X-UA-Appkey", this.getAppKey());
        return headers;
    }

    @VisibleForTesting
    public String getUserAgent() {
        String userAgent = "UNKNOWN";
        InputStream stream = this.getClass().getResourceAsStream("/client.properties");
        if (stream != null) {
            Properties props = new Properties();
            try {
                props.load(stream);
                stream.close();
                userAgent = "UAJavaLib/" + props.get("client.version") + " " + this.getAppKey();
            }
            catch (IOException e) {
                log.error("Failed to retrieve client user agent due to IOException - setting to \"UNKNOWN\"", (Throwable)e);
            }
        }
        return userAgent;
    }

    @Override
    public void close() throws IOException {
        log.info("Closing client");
        this.client.close();
    }

    public String getAppKey() {
        return this.key;
    }

    public Optional<String> getAppSecret() {
        return this.secret;
    }

    public Optional<String> getBearerToken() {
        return this.bearerToken;
    }

    public RequestClient getRequestClient() {
        return this.client;
    }

    public static class Builder {
        private String key;
        private String secret;
        private String bearerToken;
        private String baseUri = "https://go.urbanairship.com";
        private RequestClient client;

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setSecret(String appSecret) {
            this.secret = appSecret;
            return this;
        }

        public Builder setBaseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public Builder setClient(RequestClient client) {
            this.client = client;
            return this;
        }

        public UrbanAirshipClient build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"app key needed to build APIClient");
            if (this.secret == null && this.bearerToken == null) {
                throw new NullPointerException("secret or the bearer token must be set");
            }
            if (this.client == null) {
                this.client = AsyncRequestClient.newBuilder().setBaseUri(this.baseUri).build();
            }
            return new UrbanAirshipClient(this);
        }
    }
}

