/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public class Campaigns {
    private final ImmutableList<String> categories;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Campaigns(Builder builder) {
        this.categories = builder.categories.build();
    }

    public ImmutableList<String> getCategories() {
        return this.categories;
    }

    public String toString() {
        return "Campaigns{categories=" + this.categories + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.categories});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Campaigns other = (Campaigns)obj;
        return Objects.equal(this.categories, other.categories);
    }

    public static class Builder {
        private ImmutableList.Builder<String> categories = ImmutableList.builder();

        private Builder() {
        }

        public Builder addCategory(String category) {
            this.categories.add((Object)category);
            return this;
        }

        public Builder addAllCategories(Iterable<? extends String> categories) {
            this.categories.addAll(categories);
            return this;
        }

        public Campaigns build() {
            Preconditions.checkArgument((this.categories.build().size() > 0 ? 1 : 0) != 0, (Object)"Category list cannot be empty.");
            return new Campaigns(this);
        }
    }
}

