/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.attributelists;

import com.google.common.base.Preconditions;
import com.urbanairship.api.attributelists.parse.AttributeListsObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class AttributeListsCreateRequest
implements Request<String> {
    private static final String ATTRIBUTE_LISTS_PATH = "/api/attribute-lists/";
    private final String path;
    private static final String NAME_KEY = "name";
    private static final String DESCRIPTION_KEY = "description";
    private static final String EXTRAS_KEY = "extra";
    private final Map<String, String> extras = new HashMap<String, String>();
    private final Map<String, Object> payload = new HashMap<String, Object>();

    private AttributeListsCreateRequest(String path, String name) {
        this.path = path;
        this.payload.put(NAME_KEY, name);
    }

    public static AttributeListsCreateRequest newRequest(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"List name cannot be empty.");
        Preconditions.checkArgument((boolean)name.startsWith("ua_attributes_"), (Object)"You must prefix attribute list names with 'ua_attributes_'");
        return new AttributeListsCreateRequest(ATTRIBUTE_LISTS_PATH, name);
    }

    public AttributeListsCreateRequest setDescription(String description) {
        this.payload.put(DESCRIPTION_KEY, description);
        return this;
    }

    public AttributeListsCreateRequest addExtra(String key, String val) {
        this.extras.put(key, val);
        return this;
    }

    public AttributeListsCreateRequest addAllExtras(Map<String, String> entries) {
        this.extras.putAll(entries);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        if (!this.extras.isEmpty()) {
            this.payload.put(EXTRAS_KEY, this.extras);
        }
        try {
            return AttributeListsObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

