/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.channel.model.ChannelType;
import com.urbanairship.api.channel.model.email.OptInLevel;
import com.urbanairship.api.channel.model.email.OptInMode;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisterEmailChannel
extends PushModelObject {
    private final ChannelType type = ChannelType.EMAIL;
    private final Optional<Map<OptInLevel, String>> emailOptInLevel;
    private final String address;
    private final Optional<Boolean> setTags;
    private final Optional<ImmutableList<String>> tags;
    private final Optional<String> timezone;
    private final Optional<String> localeCountry;
    private final Optional<String> localeLanguage;
    private final Optional<OptInMode> emailOptInMode;
    private final Optional<Map<String, String>> properties;

    protected RegisterEmailChannel(Builder builder) {
        this.emailOptInLevel = Optional.fromNullable((Object)builder.emailOptInLevel);
        this.address = builder.address;
        this.setTags = Optional.fromNullable((Object)builder.set_tags);
        this.timezone = Optional.fromNullable((Object)builder.timezone);
        this.localeCountry = Optional.fromNullable((Object)builder.localeCountry);
        this.localeLanguage = Optional.fromNullable((Object)builder.localeLanguage);
        this.emailOptInMode = Optional.fromNullable((Object)((Object)builder.emailOptInMode));
        this.tags = builder.tags.build().isEmpty() ? Optional.absent() : Optional.of((Object)builder.tags.build());
        this.properties = !builder.properties.build().isEmpty() ? Optional.fromNullable((Object)builder.properties.build()) : Optional.absent();
    }

    public ChannelType getType() {
        return ChannelType.EMAIL;
    }

    public Optional<Map<OptInLevel, String>> getEmailOptInLevel() {
        return this.emailOptInLevel;
    }

    public String getAddress() {
        return this.address;
    }

    public Optional<String> getTimezone() {
        return this.timezone;
    }

    public Optional<String> getLocaleCountry() {
        return this.localeCountry;
    }

    public Optional<String> getLocaleLanguage() {
        return this.localeLanguage;
    }

    public Optional<OptInMode> getEmailOptInMode() {
        return this.emailOptInMode;
    }

    public Optional<Map<String, String>> getProperties() {
        return this.properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterEmailChannel that = (RegisterEmailChannel)o;
        return this.type == that.type && Objects.equal((Object)this.address, (Object)that.address) && Objects.equal(this.setTags, that.setTags) && Objects.equal(this.tags, that.tags) && Objects.equal(this.timezone, that.timezone) && Objects.equal(this.localeCountry, that.localeCountry) && Objects.equal(this.localeLanguage, that.localeLanguage) && Objects.equal(this.emailOptInLevel, that.emailOptInLevel) && Objects.equal(this.emailOptInMode, that.emailOptInMode) && Objects.equal(this.properties, that.properties);
    }

    public String toString() {
        return "RegisterEmailChannel{type=" + (Object)((Object)this.type) + ", emailOptInLevel=" + this.emailOptInLevel + ", address=" + this.address + ", setTags=" + this.setTags + ", tags=" + this.tags + ", timezone=" + this.timezone + ", localeCountry=" + this.localeCountry + ", localeLanguage=" + this.localeLanguage + ", emailOptInMode=" + this.emailOptInMode + ", properties=" + this.properties + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.emailOptInLevel, this.address, this.setTags, this.tags, this.timezone, this.localeCountry, this.localeLanguage, this.emailOptInMode, this.properties});
    }

    public static final class Builder {
        private String address;
        private String timezone;
        private ImmutableList.Builder<String> tags = ImmutableList.builder();
        private boolean set_tags;
        private String localeCountry;
        private String localeLanguage;
        private Map<OptInLevel, String> emailOptInLevel = new HashMap<OptInLevel, String>();
        private OptInMode emailOptInMode;
        private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        protected Builder() {
        }

        public Builder setEmailOptInLevel(OptInLevel level, String time) {
            this.emailOptInLevel.put(level, time);
            return this;
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setTags(boolean setTags) {
            this.set_tags = setTags;
            return this;
        }

        public Builder addAllTags(List<String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add((Object)tag);
            return this;
        }

        public Builder setTimeZone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder setLocaleCountry(String locale_country) {
            this.localeCountry = locale_country;
            return this;
        }

        public Builder setLocaleLanguage(String locale_language) {
            this.localeLanguage = locale_language;
            return this;
        }

        public Builder setEmailOptInMode(OptInMode emailOptInMode) {
            this.emailOptInMode = emailOptInMode;
            return this;
        }

        public Builder addProperty(String key, String value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllProperties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public RegisterEmailChannel build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"address cannot be null.");
            Preconditions.checkNotNull(this.emailOptInLevel, (Object)"'emailOptInLevel' cannot be null.");
            return new RegisterEmailChannel(this);
        }
    }
}

