/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Optional;

public final class RequestErrorDetails {
    private static final String ERROR_FORMAT = "\nAPIErrorDetails: \nPath:%s\nError:%s\nOptional Location:%s";
    private final String path;
    private final String error;
    private final Optional<Location> location;

    private RequestErrorDetails(String path, String error, Optional<Location> location) {
        this.path = path;
        this.error = error;
        this.location = location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getError() {
        return this.error;
    }

    public String getPath() {
        return this.path;
    }

    public Optional<Location> getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestErrorDetails that = (RequestErrorDetails)o;
        return that.path.equals(this.path) && that.error.equals(this.error) && that.location.equals(this.location);
    }

    public int hashCode() {
        return String.format("path:%s:error:%s:location:%s", this.path, this.error, this.location).hashCode();
    }

    public String toString() {
        return String.format(ERROR_FORMAT, this.path, this.error, this.location);
    }

    public static class Location {
        private final Number line;
        private final Number column;

        private Location(Number line, Number column) {
            this.line = line;
            this.column = column;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Number getLine() {
            return this.line;
        }

        public Number getColumn() {
            return this.column;
        }

        public int hashCode() {
            return String.format("line:%s:column:%s", this.line, this.column).hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location that = (Location)o;
            return this.line.equals(that.line) && this.column.equals(that.column);
        }

        public String toString() {
            return String.format("Location:\nLine:%s\nColumn:%s", this.line, this.column);
        }

        public static class Builder {
            private Number line;
            private Number column;

            private Builder() {
            }

            public Builder setLine(Number line) {
                this.line = line;
                return this;
            }

            public Builder setColumn(Number column) {
                this.column = column;
                return this;
            }

            public Location build() {
                return new Location(this.line, this.column);
            }
        }
    }

    public static class Builder {
        private String path;
        private String error;
        private Location location;

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setLocation(Location location) {
            this.location = location;
            return this;
        }

        public RequestErrorDetails build() {
            return new RequestErrorDetails(this.path, this.error, Optional.fromNullable((Object)this.location));
        }
    }
}

