/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.common.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.urbanairship.api.common.model.APIModelObject;

public final class ErrorDetails
extends APIModelObject {
    private final Optional<String> error;
    private final Optional<String> path;

    private ErrorDetails(String error, String path) {
        this.error = Optional.fromNullable((Object)error);
        this.path = Optional.fromNullable((Object)path);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorDetails that = (ErrorDetails)o;
        return Objects.equal(this.error, that.error) && Objects.equal(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.error, this.path});
    }

    public String toString() {
        return "ErrorDetails{error=" + this.error + ", path=" + this.path + '}';
    }

    public static class Builder {
        String error = null;
        String path = null;

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public ErrorDetails build() {
            return new ErrorDetails(this.error, this.path);
        }
    }
}

