/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.nameduser.model.NamedUserUpdatePayload;
import com.urbanairship.api.nameduser.model.NamedUserUpdateResponse;
import com.urbanairship.api.nameduser.parse.NamedUserObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class NamedUserUpdateRequest
implements Request<NamedUserUpdateResponse> {
    private static final String API_NAMED_USER = "/api/named_users/";
    private static final ObjectMapper MAPPER = NamedUserObjectMapper.getInstance();
    private final String namedUser;
    private final String path;
    private final NamedUserUpdatePayload payload;

    private NamedUserUpdateRequest(String namedUser, NamedUserUpdatePayload payload) {
        this.path = API_NAMED_USER + namedUser;
        this.namedUser = namedUser;
        this.payload = payload;
    }

    public static NamedUserUpdateRequest newRequest(String namedUser, NamedUserUpdatePayload payload) {
        Preconditions.checkNotNull((Object)namedUser, (Object)"Named user must be set.");
        return new NamedUserUpdateRequest(namedUser, payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<NamedUserUpdateResponse> getResponseParser() {
        return new ResponseParser<NamedUserUpdateResponse>(){

            @Override
            public NamedUserUpdateResponse parse(String response) throws IOException {
                return (NamedUserUpdateResponse)MAPPER.readValue(response, NamedUserUpdateResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

