/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.Campaigns;
import com.urbanairship.api.push.model.DeviceTypeData;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.PushOptions;
import com.urbanairship.api.push.model.audience.Selector;
import com.urbanairship.api.push.model.audience.SelectorType;
import com.urbanairship.api.push.model.localization.Localization;
import com.urbanairship.api.push.model.notification.Notification;
import com.urbanairship.api.push.model.notification.richpush.RichPushMessage;

public final class PushPayload
extends PushModelObject {
    private final Selector audience;
    private final Optional<Notification> notification;
    private final Optional<ImmutableList<Localization>> localizations;
    private final Optional<RichPushMessage> message;
    private final DeviceTypeData deviceTypes;
    private final Optional<PushOptions> pushOptions;
    private final Optional<InApp> inApp;
    private final Optional<Campaigns> campaigns;
    private final ImmutableMap<String, Object> globalAttributes;

    public static Builder newBuilder() {
        return new Builder();
    }

    private PushPayload(Selector audience, Optional<Notification> notification, Optional<RichPushMessage> message, DeviceTypeData deviceTypes, Optional<PushOptions> pushOptions, Optional<InApp> inApp, Optional<Campaigns> campaigns, ImmutableList<Localization> localizations, ImmutableMap<String, Object> globalAttributes) {
        this.audience = audience;
        this.notification = notification;
        this.message = message;
        this.deviceTypes = deviceTypes;
        this.pushOptions = pushOptions;
        this.inApp = inApp;
        this.campaigns = campaigns;
        this.globalAttributes = globalAttributes;
        this.localizations = localizations.isEmpty() ? Optional.absent() : Optional.of(localizations);
    }

    public Selector getAudience() {
        return this.audience;
    }

    public Optional<Notification> getNotification() {
        return this.notification;
    }

    public Optional<RichPushMessage> getMessage() {
        return this.message;
    }

    public DeviceTypeData getDeviceTypes() {
        return this.deviceTypes;
    }

    public boolean isBroadcast() {
        return this.audience.getType().equals((Object)SelectorType.ALL);
    }

    public Optional<InApp> getInApp() {
        return this.inApp;
    }

    public Optional<PushOptions> getPushOptions() {
        return this.pushOptions;
    }

    public Optional<Campaigns> getCampaigns() {
        return this.campaigns;
    }

    public Optional<ImmutableList<Localization>> getLocalizations() {
        return this.localizations;
    }

    public ImmutableMap<String, Object> getGlobalAttributes() {
        return this.globalAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushPayload that = (PushPayload)o;
        if (this.audience != null ? !this.audience.equals(that.audience) : that.audience != null) {
            return false;
        }
        if (this.notification != null ? !this.notification.equals(that.notification) : that.notification != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.deviceTypes != null ? !this.deviceTypes.equals(that.deviceTypes) : that.deviceTypes != null) {
            return false;
        }
        if (this.pushOptions != null ? !this.pushOptions.equals(that.pushOptions) : that.pushOptions != null) {
            return false;
        }
        if (this.inApp != null ? !this.inApp.equals(that.inApp) : that.inApp != null) {
            return false;
        }
        if (this.campaigns != null ? !this.campaigns.equals(that.campaigns) : that.campaigns != null) {
            return false;
        }
        return !(this.globalAttributes != null ? !this.globalAttributes.equals(that.globalAttributes) : that.globalAttributes != null);
    }

    public int hashCode() {
        int result = this.audience != null ? this.audience.hashCode() : 0;
        result = 31 * result + (this.notification != null ? this.notification.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.deviceTypes != null ? this.deviceTypes.hashCode() : 0);
        result = 31 * result + (this.pushOptions != null ? this.pushOptions.hashCode() : 0);
        result = 31 * result + (this.inApp != null ? this.inApp.hashCode() : 0);
        result = 31 * result + (this.campaigns != null ? this.campaigns.hashCode() : 0);
        result = 31 * result + (this.globalAttributes != null ? this.globalAttributes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PushPayload{audience=" + this.audience + ", notification=" + this.notification + ", message=" + this.message + ", deviceTypes=" + this.deviceTypes + ", pushOptions=" + this.pushOptions + ", inApp=" + this.inApp + ", campaigns=" + this.campaigns + ", globalAttributes=" + this.globalAttributes + '}';
    }

    public static class Builder {
        private DeviceTypeData deviceTypes = null;
        private Selector audience = null;
        private Notification notification = null;
        private RichPushMessage message = null;
        private PushOptions pushOptions = null;
        private InApp inApp = null;
        private Campaigns campaigns = null;
        private ImmutableList.Builder<Localization> localizationsBuilder = ImmutableList.builder();
        private ImmutableMap.Builder<String, Object> globalAttributesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setAudience(Selector value) {
            this.audience = value;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setMessage(RichPushMessage message) {
            this.message = message;
            return this;
        }

        public Builder setDeviceTypes(DeviceTypeData deviceTypes) {
            this.deviceTypes = deviceTypes;
            return this;
        }

        public Builder setPushOptions(PushOptions pushOptions) {
            this.pushOptions = pushOptions;
            return this;
        }

        public Builder setInApp(InApp inApp) {
            this.inApp = inApp;
            return this;
        }

        public Builder setCampaigns(Campaigns campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        public Builder addLocalization(Localization localization) {
            this.localizationsBuilder.add((Object)localization);
            return this;
        }

        public Builder addGlobalAttributes(String k, Object o) {
            this.globalAttributesBuilder.put((Object)k, o);
            return this;
        }

        public PushPayload build() {
            ImmutableList localizations = this.localizationsBuilder.build();
            ImmutableMap globalAttributes = this.globalAttributesBuilder.build();
            Preconditions.checkArgument((this.notification != null || this.message != null || this.inApp != null ? 1 : 0) != 0, (Object)"At least one of 'notification', 'message', or 'inApp' must be set.");
            Preconditions.checkNotNull((Object)this.audience, (Object)"'audience' must be set");
            Preconditions.checkNotNull((Object)this.deviceTypes, (Object)"'device_types' must be set");
            return new PushPayload(this.audience, Optional.fromNullable((Object)this.notification), Optional.fromNullable((Object)this.message), this.deviceTypes, Optional.fromNullable((Object)this.pushOptions), Optional.fromNullable((Object)this.inApp), Optional.fromNullable((Object)this.campaigns), localizations, globalAttributes);
        }
    }
}

