/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.push.model.notification.android.Style;

public class InboxStyle
implements Style<ImmutableList<String>> {
    private final ImmutableList<String> content;
    private final Optional<String> title;
    private final Optional<String> summary;

    private InboxStyle(Builder builder) {
        this.content = builder.content.build();
        this.title = Optional.of((Object)builder.title);
        this.summary = Optional.of((Object)builder.summary);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public ImmutableList<String> getContent() {
        return this.content;
    }

    @Override
    public Style.Type getType() {
        return Style.Type.INBOX;
    }

    @Override
    public Optional<String> getTitle() {
        return this.title;
    }

    @Override
    public Optional<String> getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboxStyle that = (InboxStyle)o;
        if (!this.content.equals(that.content)) {
            return false;
        }
        if (!this.summary.equals(that.summary)) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public String toString() {
        return "InboxStyle{content=" + this.content + ", title=" + this.title + ", summary=" + this.summary + '}';
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.summary.hashCode();
        return result;
    }

    public static class Builder {
        private ImmutableList.Builder<String> content = ImmutableList.builder();
        private String title = null;
        private String summary = null;

        public Builder addLine(String line) {
            this.content.add((Object)line);
            return this;
        }

        public Builder addLines(Iterable<? extends String> lines) {
            this.content.addAll(lines);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public InboxStyle build() {
            Preconditions.checkNotNull((Object)(!this.content.build().isEmpty() ? 1 : 0), (Object)"The content field cannot be null.");
            return new InboxStyle(this);
        }
    }
}

