/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.urbanairship.api.push.parse.PushObjectMapper;
import com.urbanairship.api.reports.model.DeviceStats;
import com.urbanairship.api.reports.model.DeviceTypeStats;
import com.urbanairship.api.reports.model.DevicesReport;
import com.urbanairship.api.reports.model.DevicesReportResponse;
import com.urbanairship.api.reports.model.PlatformStats;
import com.urbanairship.api.reports.model.PlatformStatsResponse;
import com.urbanairship.api.reports.model.PushInfoResponse;
import com.urbanairship.api.reports.model.PushListingResponse;
import com.urbanairship.api.reports.model.ResponseReport;
import com.urbanairship.api.reports.model.ResponseReportResponse;
import com.urbanairship.api.reports.model.StatisticsResponse;
import com.urbanairship.api.reports.parse.DeviceStatsDeserializer;
import com.urbanairship.api.reports.parse.DeviceTypeStatsDeserializer;
import com.urbanairship.api.reports.parse.DevicesReportDeserializer;
import com.urbanairship.api.reports.parse.DevicesReportResponseDeserializer;
import com.urbanairship.api.reports.parse.PlatformStatsDeserializer;
import com.urbanairship.api.reports.parse.PlatformStatsResponseDeserializer;
import com.urbanairship.api.reports.parse.PushInfoResponseDeserializer;
import com.urbanairship.api.reports.parse.PushListingResponseDeserializer;
import com.urbanairship.api.reports.parse.ResponseReportDeserializer;
import com.urbanairship.api.reports.parse.ResponseReportResponseDeserializer;
import com.urbanairship.api.reports.parse.StatisticsResponseDeserializer;

public class ReportsObjectMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final SimpleModule MODULE = new SimpleModule("Reports API Module");

    public static SimpleModule getModule() {
        return MODULE;
    }

    public static ObjectMapper getInstance() {
        return MAPPER;
    }

    private ReportsObjectMapper() {
    }

    static {
        MODULE.addDeserializer(DeviceStats.class, (JsonDeserializer)new DeviceStatsDeserializer());
        MODULE.addDeserializer(DeviceTypeStats.class, (JsonDeserializer)new DeviceTypeStatsDeserializer());
        MODULE.addDeserializer(DevicesReport.class, (JsonDeserializer)new DevicesReportDeserializer());
        MODULE.addDeserializer(DevicesReportResponse.class, (JsonDeserializer)new DevicesReportResponseDeserializer());
        MODULE.addDeserializer(PlatformStats.class, (JsonDeserializer)new PlatformStatsDeserializer());
        MODULE.addDeserializer(PlatformStatsResponse.class, (JsonDeserializer)new PlatformStatsResponseDeserializer());
        MODULE.addDeserializer(PushInfoResponse.class, (JsonDeserializer)new PushInfoResponseDeserializer());
        MODULE.addDeserializer(PushListingResponse.class, (JsonDeserializer)new PushListingResponseDeserializer());
        MODULE.addDeserializer(ResponseReport.class, (JsonDeserializer)new ResponseReportDeserializer());
        MODULE.addDeserializer(ResponseReportResponse.class, (JsonDeserializer)new ResponseReportResponseDeserializer());
        MODULE.addDeserializer(StatisticsResponse.class, (JsonDeserializer)new StatisticsResponseDeserializer());
        MAPPER.registerModule((Module)MODULE);
        MAPPER.registerModule((Module)PushObjectMapper.getModule());
    }
}

