/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;

public class ScheduleStatusRequest
implements Request<String> {
    private final String scheduleId;
    private final String status;

    private ScheduleStatusRequest(String scheduleId, String status) {
        this.scheduleId = scheduleId;
        this.status = status;
    }

    public static ScheduleStatusRequest pauseScheduleRequest(String scheduleId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"Schedule ID may not be null");
        return new ScheduleStatusRequest(scheduleId, Status.PAUSE.getStatus());
    }

    public static ScheduleStatusRequest resumeScheduleRequest(String scheduleId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)scheduleId), (Object)"Schedule ID may not be null");
        return new ScheduleStatusRequest(scheduleId, Status.RESUME.getStatus());
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, "/api/schedules/" + this.scheduleId + "/" + this.status);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return new ResponseParser<String>(){

            @Override
            public String parse(String response) throws IOException {
                return response;
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    public static enum Status {
        PAUSE("pause"),
        RESUME("resume");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

