/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.staticlists;

import com.google.common.base.Optional;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.staticlists.model.StaticListListingResponse;
import com.urbanairship.api.staticlists.parse.StaticListsObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;

public class StaticListListingRequest
implements Request<StaticListListingResponse> {
    private static final String API_LISTS_PATH = "/api/lists/";
    private static final String TYPE_PARAM = "type";
    private Optional<ListType> type = Optional.absent();

    private StaticListListingRequest() {
    }

    public static StaticListListingRequest newRequest() {
        return new StaticListListingRequest();
    }

    public StaticListListingRequest type(ListType type) {
        this.type = Optional.of((Object)((Object)type));
        return this;
    }

    @Override
    public ContentType getContentType() {
        return null;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.GET;
    }

    @Override
    public String getRequestBody() {
        return null;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(RequestUtils.resolveURI(baseUri, API_LISTS_PATH));
        if (this.type.isPresent()) {
            builder.addParameter(TYPE_PARAM, ((ListType)((Object)this.type.get())).toString());
        }
        return builder.build();
    }

    @Override
    public ResponseParser<StaticListListingResponse> getResponseParser() {
        return new ResponseParser<StaticListListingResponse>(){

            @Override
            public StaticListListingResponse parse(String response) throws IOException {
                return (StaticListListingResponse)StaticListsObjectMapper.getInstance().readValue(response, StaticListListingResponse.class);
            }
        };
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }

    public static enum ListType {
        all,
        lifecycle,
        user;

    }
}

