/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestClient;
import com.urbanairship.api.client.RequestRetryFilter;
import com.urbanairship.api.client.Response;
import com.urbanairship.api.client.ResponseAsyncHandler;
import com.urbanairship.api.client.ResponseCallback;
import com.urbanairship.api.client.UrbanAirshipClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.apache.http.entity.ContentType;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.proxy.ProxyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRequestClient
implements RequestClient {
    private static final Logger log = LoggerFactory.getLogger(UrbanAirshipClient.class);
    private final Optional<ProxyServer> proxyServer;
    private final URI baseUri;
    private final AsyncHttpClient client;
    private final DefaultAsyncHttpClientConfig clientConfig;

    private AsyncRequestClient(Builder builder) {
        this.baseUri = URI.create(builder.baseUri);
        DefaultAsyncHttpClientConfig.Builder clientConfigBuilder = builder.clientConfigBuilder;
        clientConfigBuilder.addResponseFilter((ResponseFilter)new RequestRetryFilter(builder.maxRetries, Optional.ofNullable(builder.retryPredicate)));
        if (Optional.ofNullable(builder.proxyServer).isPresent()) {
            this.proxyServer = Optional.ofNullable(builder.proxyServer);
            clientConfigBuilder.setProxyServer(this.proxyServer.get());
            clientConfigBuilder.setRealm(this.proxyServer.get().getRealm());
        } else {
            this.proxyServer = Optional.empty();
        }
        this.clientConfig = clientConfigBuilder.build();
        this.client = new DefaultAsyncHttpClient((AsyncHttpClientConfig)this.clientConfig);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public Optional<ProxyServer> getProxyServer() {
        return this.proxyServer;
    }

    public DefaultAsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public <T> Future<Response> executeAsync(Request<T> request, ResponseCallback callback, Map<String, String> headers) {
        BoundRequestBuilder requestBuilder;
        String uri;
        try {
            uri = request.getUri(this.baseUri).toString();
        }
        catch (URISyntaxException e) {
            log.error("Failed to generate a request URI from base URI " + this.baseUri.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        switch (request.getHttpMethod()) {
            case GET: {
                requestBuilder = this.client.prepareGet(uri);
                break;
            }
            case PUT: {
                requestBuilder = this.client.preparePut(uri);
                break;
            }
            case POST: {
                requestBuilder = this.client.preparePost(uri);
                break;
            }
            case DELETE: {
                requestBuilder = this.client.prepareDelete(uri);
                break;
            }
            default: {
                requestBuilder = this.client.prepareGet(uri);
            }
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            requestBuilder.addHeader((CharSequence)entry.getKey(), entry.getValue());
        }
        String body = request.getRequestBody();
        ContentType contentType = request.getContentType();
        if (body != null && contentType != null) {
            requestBuilder.setBody(body.getBytes(contentType.getCharset()));
        }
        log.debug(String.format("Executing Urban Airship request to %s with body %s.", uri, request.getRequestBody()));
        ResponseAsyncHandler<T> handler = new ResponseAsyncHandler<T>(Optional.ofNullable(callback), request.getResponseParser());
        return requestBuilder.execute(handler);
    }

    @Override
    public void close() throws IOException {
        log.info("Closing client");
        this.client.close();
    }

    public static class Builder {
        private String baseUri = "https://go.urbanairship.com";
        private Integer maxRetries = 10;
        private DefaultAsyncHttpClientConfig.Builder clientConfigBuilder = new DefaultAsyncHttpClientConfig.Builder();
        private Predicate<FilterContext> retryPredicate = null;
        private ProxyServer proxyServer;

        private Builder() {
        }

        public Builder setBaseUri(String URI2) {
            this.baseUri = URI2;
            return this;
        }

        public Builder setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setClientConfigBuilder(DefaultAsyncHttpClientConfig.Builder clientConfigBuilder) {
            this.clientConfigBuilder = clientConfigBuilder;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            return this;
        }

        public Builder setRetryPredicate(Predicate<FilterContext> retryPredicate) {
            this.retryPredicate = retryPredicate;
            return this;
        }

        public AsyncRequestClient build() {
            Preconditions.checkNotNull((Object)this.baseUri, (Object)"base URI needed to build APIClient");
            Preconditions.checkNotNull((Object)this.maxRetries, (Object)"max non-POST retries needed to build APIClient");
            Preconditions.checkNotNull((Object)this.clientConfigBuilder, (Object)"Async HTTP client config builder needed to build APIClient");
            return new AsyncRequestClient(this);
        }
    }
}

