/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.ResponseAsyncHandler;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang.math.RandomUtils;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.ResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestRetryFilter
implements ResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(RequestRetryFilter.class);
    private static final int BASE_RETRY_TIME_MS = 5;
    private static final Predicate<FilterContext> DEFAULT_PREDICATE = new Predicate<FilterContext>(){

        @Override
        public boolean test(FilterContext input) {
            return !input.getRequest().getMethod().equals("POST") && input.getResponseStatus().getStatusCode() >= 500;
        }
    };
    private final int maxRetries;
    private final Predicate<FilterContext> retryPredicate;

    public RequestRetryFilter(int maxRetries, Optional<Predicate<FilterContext>> retryPredicate) {
        this.maxRetries = maxRetries;
        this.retryPredicate = retryPredicate.isPresent() ? retryPredicate.get() : DEFAULT_PREDICATE;
    }

    public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
        int statusCode = ctx.getResponseStatus().getStatusCode();
        if (ctx.getAsyncHandler() instanceof ResponseAsyncHandler) {
            ResponseAsyncHandler asyncHandler = (ResponseAsyncHandler)ctx.getAsyncHandler();
            if (asyncHandler.getRetryCount() < this.maxRetries && this.retryPredicate.test(ctx)) {
                try {
                    int sleepTime = 5 * Math.max(1, RandomUtils.nextInt((int)(1 << asyncHandler.getRetryCount() + 1)));
                    log.info(String.format("Request failed with status code %s - waiting for %s ms before retrying request", statusCode, sleepTime));
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                asyncHandler.incrementRetryCount();
                return new FilterContext.FilterContextBuilder(ctx).request(ctx.getRequest()).replayRequest(true).build();
            }
            if (asyncHandler.getRetryCount() >= this.maxRetries && this.retryPredicate.test(ctx)) {
                log.warn(String.format("Request failed with status code %s after %s attempts", statusCode, asyncHandler.getRetryCount()));
                return ctx;
            }
        }
        return ctx;
    }
}

