/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification;

import com.google.common.base.Preconditions;
import com.urbanairship.api.createandsend.model.audience.CreateAndSendAudience;
import com.urbanairship.api.push.model.Campaigns;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.Notification;
import java.util.Objects;
import java.util.Optional;

public class CreateAndSendPayload
extends PushModelObject {
    private final CreateAndSendAudience audience;
    private final Notification notification;
    private final Optional<Campaigns> campaigns;

    private CreateAndSendPayload(Builder builder) {
        this.audience = builder.audience;
        this.notification = builder.notification;
        this.campaigns = Optional.ofNullable(builder.campaigns);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CreateAndSendAudience getAudience() {
        return this.audience;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public Optional<Campaigns> getCampaigns() {
        return this.campaigns;
    }

    public String toString() {
        return "CreateAndSendPayload{audience=" + this.audience + ", notification=" + this.notification + ", campaigns=" + this.campaigns + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAndSendPayload)) {
            return false;
        }
        CreateAndSendPayload that = (CreateAndSendPayload)o;
        return Objects.equals(this.getAudience(), that.getAudience()) && Objects.equals(this.getNotification(), that.getNotification()) && Objects.equals(this.getCampaigns(), that.getCampaigns());
    }

    public int hashCode() {
        return Objects.hash(this.getAudience(), this.getNotification(), this.getCampaigns());
    }

    public static class Builder {
        private CreateAndSendAudience audience;
        private Notification notification;
        private Campaigns campaigns;

        private Builder() {
        }

        public Builder setAudience(CreateAndSendAudience audience) {
            this.audience = audience;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setCampaigns(Campaigns campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        public CreateAndSendPayload build() {
            Preconditions.checkNotNull((Object)this.notification, (Object)"Notification must be set.");
            Preconditions.checkNotNull((Object)this.audience, (Object)"Audience must be set.");
            return new CreateAndSendPayload(this);
        }
    }
}

