/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.InApp;
import com.urbanairship.api.push.model.PushOptions;
import com.urbanairship.api.push.model.notification.Notification;
import java.util.Optional;

public class VariantPushPayload {
    private final Optional<Notification> notification;
    private final Optional<PushOptions> pushOptions;
    private final Optional<InApp> inApp;

    private VariantPushPayload(Builder builder) {
        this.notification = Optional.ofNullable(builder.notification);
        this.pushOptions = Optional.ofNullable(builder.pushOptions);
        this.inApp = Optional.ofNullable(builder.inApp);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Notification> getNotification() {
        return this.notification;
    }

    public Optional<PushOptions> getPushOptions() {
        return this.pushOptions;
    }

    public Optional<InApp> getInApp() {
        return this.inApp;
    }

    public String toString() {
        return "VariantPushPayload{notification=" + this.notification + ", pushOptions=" + this.pushOptions + ", inApp=" + this.inApp + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.notification, this.pushOptions, this.inApp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VariantPushPayload other = (VariantPushPayload)obj;
        return Objects.equal(this.notification, other.notification) && Objects.equal(this.pushOptions, other.pushOptions) && Objects.equal(this.inApp, other.inApp);
    }

    public static class Builder {
        private Notification notification = null;
        private PushOptions pushOptions = null;
        private InApp inApp = null;

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setPushOptions(PushOptions pushOptions) {
            this.pushOptions = pushOptions;
            return this;
        }

        public Builder setInApp(InApp inApp) {
            this.inApp = inApp;
            return this;
        }

        public VariantPushPayload build() {
            Preconditions.checkArgument((this.notification != null || this.inApp != null ? 1 : 0) != 0, (Object)"At least one of 'notification' or 'inApp' must be set.");
            return new VariantPushPayload(this);
        }
    }
}

