/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.actions;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.actions.Action;
import com.urbanairship.api.push.model.notification.actions.ActionType;
import java.util.Optional;

public class DeepLinkAction
implements Action.OpenAction<String> {
    private final String link;
    private final Optional<String> fallbackUrl;

    public DeepLinkAction(String link) {
        this(link, Optional.empty());
    }

    public DeepLinkAction(String link, String fallbackUrl) {
        this(link, Optional.ofNullable(fallbackUrl));
    }

    private DeepLinkAction(String link, Optional<String> fallbackUrl) {
        Preconditions.checkNotNull((Object)link, (Object)"link should not be null.");
        Preconditions.checkNotNull(fallbackUrl, (Object)"fallbackUrl should not be null.");
        this.link = link;
        this.fallbackUrl = fallbackUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeepLinkAction that = (DeepLinkAction)o;
        return Objects.equal((Object)this.link, (Object)that.link) && Objects.equal(this.fallbackUrl, that.fallbackUrl);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.link, this.fallbackUrl});
    }

    public String toString() {
        return "DeepLinkAction{link='" + this.link + '\'' + ", fallbackUrl=" + this.fallbackUrl + '}';
    }

    @Override
    public String getValue() {
        return this.link;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.OPEN_DEEP_LINK;
    }

    public String getLink() {
        return this.link;
    }

    public Optional<String> getFallbackUrl() {
        return this.fallbackUrl;
    }
}

