/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.RequestError;
import java.util.Optional;

public class ClientException
extends RuntimeException {
    private final Optional<RequestError> error;
    private final Integer statusCode;
    private final String statusText;

    private ClientException(String statusText, Integer statusCode, Optional<RequestError> error) {
        super(statusText);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.error = error;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<RequestError> getError() {
        return this.error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nClientException:");
        stringBuilder.append(String.format("\nMessage:%s", this.getMessage()));
        stringBuilder.append(String.format("\nStatusCode:%s", this.statusCode));
        stringBuilder.append(String.format("\nStatusText:%s", this.statusText));
        if (this.error.isPresent()) {
            stringBuilder.append(String.format("\nError:%s", this.error.get()));
        }
        if (this.getCause() != null) {
            stringBuilder.append(String.format("\nCause:%s", this.getCause().getMessage()));
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private Integer statusCode;
        private String statusText;
        private RequestError requestError = null;

        public Builder setStatusText(String statusText) {
            this.statusText = statusText;
            return this;
        }

        public Builder setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setRequestError(RequestError requestError) {
            this.requestError = requestError;
            return this;
        }

        public ClientException build() {
            return new ClientException(this.statusText, this.statusCode, Optional.ofNullable(this.requestError));
        }
    }
}

