/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import java.util.Optional;

public final class PushResponse {
    private final Optional<String> operationId;
    private final Optional<ImmutableList<String>> pushIds;
    private final boolean ok;
    private final Optional<ImmutableList<String>> messageIds;
    private final Optional<ImmutableList<String>> contentUrls;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    public PushResponse(String operationId, ImmutableList<String> pushIds, boolean ok, ImmutableList<String> messageIds, ImmutableList<String> contentUrls, String error, ErrorDetails errorDetails) {
        this.operationId = Optional.ofNullable(operationId);
        this.pushIds = Optional.ofNullable(pushIds);
        this.ok = ok;
        this.messageIds = Optional.ofNullable(messageIds);
        this.contentUrls = Optional.ofNullable(contentUrls);
        this.error = Optional.ofNullable(error);
        this.errorDetails = Optional.ofNullable(errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public Optional<ImmutableList<String>> getPushIds() {
        return this.pushIds;
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<ImmutableList<String>> getMessageIds() {
        return this.messageIds;
    }

    public Optional<ImmutableList<String>> getContentUrls() {
        return this.contentUrls;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "PushResponse{operationId=" + this.operationId + ", pushIds=" + this.pushIds + ", ok=" + this.ok + ", messagesIds=" + this.messageIds + ", contentUrls=" + this.contentUrls + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operationId, this.pushIds, this.ok, this.messageIds, this.contentUrls, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PushResponse other = (PushResponse)obj;
        return Objects.equal(this.operationId, other.operationId) && Objects.equal(this.pushIds, other.pushIds) && Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.messageIds, other.messageIds) && Objects.equal(this.contentUrls, other.contentUrls) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private String operationId;
        private ImmutableList.Builder<String> pushIds = ImmutableList.builder();
        private boolean ok = false;
        private ImmutableList.Builder<String> messageIds = ImmutableList.builder();
        private ImmutableList.Builder<String> contentUrls = ImmutableList.builder();
        private String error;
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder addPushId(String pushId) {
            this.pushIds.add((Object)pushId);
            return this;
        }

        public Builder addAllPushIds(Iterable<? extends String> pushIds) {
            this.pushIds.addAll(pushIds);
            return this;
        }

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder addMessageId(String messageId) {
            this.messageIds.add((Object)messageId);
            return this;
        }

        public Builder addAllMessageIds(Iterable<? extends String> messageIds) {
            this.messageIds.addAll(messageIds);
            return this;
        }

        public Builder addContentUrl(String contentUrl) {
            this.contentUrls.add((Object)contentUrl);
            return this;
        }

        public Builder addAllContentUrls(Iterable<? extends String> contentUrls) {
            this.contentUrls.addAll(contentUrls);
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public PushResponse build() {
            return new PushResponse(this.operationId, (ImmutableList<String>)this.pushIds.build(), this.ok, (ImmutableList<String>)this.messageIds.build(), (ImmutableList<String>)this.contentUrls.build(), this.error, this.errorDetails);
        }
    }
}

