/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.wns;

import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.wns.WNSPush;
import java.util.Optional;

public final class WNSDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<WNSPush> body;
    private final Optional<String> alert;

    private WNSDevicePayload(Optional<WNSPush> body, Optional<String> alert) {
        this.body = body;
        this.alert = alert;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.WNS;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public WNSPush.Type getType() {
        if (this.body.isPresent()) {
            return this.body.get().getType();
        }
        return WNSPush.Type.TOAST;
    }

    public Optional<WNSPush> getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WNSDevicePayload that = (WNSDevicePayload)o;
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        return !(this.alert == null ? that.alert != null : !this.alert.equals(that.alert));
    }

    public int hashCode() {
        int result = this.body != null ? this.body.hashCode() : 0;
        result = 31 * result + (this.alert != null ? this.alert.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String alert;
        private WNSPush body;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setBody(WNSPush body) {
            this.body = body;
            return this;
        }

        public WNSDevicePayload build() {
            return new WNSDevicePayload(Optional.ofNullable(this.body), Optional.ofNullable(this.alert));
        }
    }
}

