/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.tags;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class TagListRequest
implements Request<String> {
    private static final String CREATE_TAG_LIST_PATH = "/api/tag-lists";
    private static final String NAME_KEY = "name";
    private static final String DESCRIPTION_KEY = "description";
    private static final String EXTRAS_KEY = "extra";
    private static final String ADD_KEY = "add";
    private static final String REMOVE_KEY = "remove";
    private static final String SET_KEY = "set";
    private final Map<String, ImmutableSet<String>> addTags = new HashMap<String, ImmutableSet<String>>();
    private final Map<String, ImmutableSet<String>> removeTags = new HashMap<String, ImmutableSet<String>>();
    private final Map<String, ImmutableSet<String>> setTags = new HashMap<String, ImmutableSet<String>>();
    private final Map<String, String> extras = new HashMap<String, String>();
    private ObjectNode payload = JsonNodeFactory.instance.objectNode();

    public static TagListRequest newRequest() {
        return new TagListRequest();
    }

    public TagListRequest setName(String name) {
        this.payload.put(NAME_KEY, name);
        return this;
    }

    public TagListRequest setDescription(String description) {
        this.payload.put(DESCRIPTION_KEY, description);
        return this;
    }

    public TagListRequest addExtra(String key, String val) {
        this.extras.put(key, val);
        return this;
    }

    public TagListRequest addTags(String tagGroup, ImmutableSet<String> tags) {
        this.addTags.put(tagGroup, tags);
        return this;
    }

    public TagListRequest removeTags(String tagGroup, ImmutableSet<String> tags) {
        this.removeTags.put(tagGroup, tags);
        return this;
    }

    public TagListRequest setTags(String tagGroup, ImmutableSet<String> tags) {
        this.setTags.put(tagGroup, tags);
        return this;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        if (!this.addTags.isEmpty()) {
            this.payload.putPOJO(ADD_KEY, this.addTags);
        }
        if (!this.removeTags.isEmpty()) {
            this.payload.putPOJO(REMOVE_KEY, this.removeTags);
        }
        if (!this.setTags.isEmpty()) {
            this.payload.putPOJO(SET_KEY, this.setTags);
        }
        if (!this.extras.isEmpty()) {
            this.payload.putPOJO(EXTRAS_KEY, this.extras);
        }
        Preconditions.checkArgument((boolean)this.payload.has(NAME_KEY), (Object)"Name required when executing a tag list operation");
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString((Object)this.payload);
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getClass().getName() + "\", \"message\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, CREATE_TAG_LIST_PATH);
    }

    @Override
    public ResponseParser<String> getResponseParser() {
        return response -> response;
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

