/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbanairship.api.channel.model.ChannelUninstallPayload;
import com.urbanairship.api.channel.model.ChannelUninstallResponse;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ChannelUninstallRequest
implements Request<ChannelUninstallResponse> {
    private static final String API_CHANNELS_UNINSTALL_PATH = "/api/channels/uninstall/";
    private static final ObjectMapper MAPPER = ChannelObjectMapper.getInstance();
    private final ChannelUninstallPayload payload;

    private ChannelUninstallRequest(ChannelUninstallPayload payload) {
        this.payload = payload;
    }

    public static ChannelUninstallRequest newRequest(ChannelUninstallPayload payload) {
        return new ChannelUninstallRequest(payload);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString(this.payload.getChannels());
        }
        catch (Exception ex) {
            return "{ \"exception\" : \"" + ex.getMessage() + "\" }";
        }
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, API_CHANNELS_UNINSTALL_PATH);
    }

    @Override
    public ResponseParser<ChannelUninstallResponse> getResponseParser() {
        return response -> (ChannelUninstallResponse)MAPPER.readValue(response, ChannelUninstallResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

