/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.web;

import com.google.common.base.Objects;
import com.urbanairship.api.channel.model.web.Subscription;
import java.util.Optional;

public final class WebSettings {
    private final Optional<Subscription> subscription;

    private WebSettings(Optional<Subscription> subscription) {
        this.subscription = subscription;
    }

    public Optional<Subscription> getSubscription() {
        return this.subscription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSettings webSettings = (WebSettings)o;
        return Objects.equal(this.subscription, webSettings.subscription);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subscription});
    }

    public String toString() {
        return "WebSettings{subscription=" + this.subscription + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Subscription subscription = null;

        private Builder() {
        }

        public Builder setSubscription(Subscription subscription) {
            this.subscription = subscription;
            return this;
        }

        public WebSettings build() {
            return new WebSettings(Optional.ofNullable(this.subscription));
        }
    }
}

