/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.reports.model.PlatformStats;
import java.io.IOException;

public final class PlatformStatsReader
implements JsonObjectReader<PlatformStats> {
    private final PlatformStats.Builder builder = PlatformStats.newBuilder();

    public void readAndroid(JsonParser jsonParser) throws IOException {
        this.builder.setAndroid((Integer)jsonParser.readValueAs(Integer.TYPE));
    }

    public void readIOS(JsonParser jsonParser) throws IOException {
        this.builder.setIOS((Integer)jsonParser.readValueAs(Integer.TYPE));
    }

    public void readDate(JsonParser jsonParser) throws IOException {
        String created = (String)jsonParser.readValueAs(String.class);
        this.builder.setDate(DateFormats.DATE_PARSER.parseDateTime(created));
    }

    @Override
    public PlatformStats validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

