/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.schedule.model.ScheduleModelObject;
import com.urbanairship.api.schedule.model.SchedulePayloadResponse;

public final class ScheduleDetails
extends ScheduleModelObject {
    private final String jobId;
    private final SchedulePayloadResponse schedulePayloadResponse;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ScheduleDetails(String jobId, SchedulePayloadResponse schedulePayloadResponse) {
        this.schedulePayloadResponse = schedulePayloadResponse;
        this.jobId = jobId;
    }

    public SchedulePayloadResponse getSchedulePayloadResponse() {
        return this.schedulePayloadResponse;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String toString() {
        return "ScheduleDetails{jobId='" + this.jobId + '\'' + ", schedulePayloadResponse=" + this.schedulePayloadResponse + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.jobId, this.schedulePayloadResponse});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleDetails other = (ScheduleDetails)obj;
        return Objects.equal((Object)this.jobId, (Object)other.jobId) && Objects.equal((Object)this.schedulePayloadResponse, (Object)other.schedulePayloadResponse);
    }

    public static final class Builder {
        private String jobId = null;
        private SchedulePayloadResponse schedulePayloadResponse = null;

        private Builder() {
        }

        public Builder setSchedulePayloadResponse(SchedulePayloadResponse schedulePayloadResponse) {
            this.schedulePayloadResponse = schedulePayloadResponse;
            return this;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public ScheduleDetails build() {
            Preconditions.checkNotNull((Object)this.schedulePayloadResponse, (Object)"schedule payload must be provided");
            Preconditions.checkNotNull((Object)this.jobId, (Object)"job id must be provided");
            return new ScheduleDetails(this.jobId, this.schedulePayloadResponse);
        }
    }
}

