/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.android.AndroidLiveUpdateEvent;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class AndroidLiveUpdate
extends PushModelObject {
    private final Optional<Map<String, String>> contentState;
    private final Optional<Integer> dismissalDate;
    private final AndroidLiveUpdateEvent androidLiveUpdateEvent;
    private final String name;
    private final Optional<Integer> timestamp;
    private final Optional<String> type;

    private AndroidLiveUpdate(Optional<Map<String, String>> contentState, Optional<Integer> dismissalDate, AndroidLiveUpdateEvent androidLiveUpdateEvent, String name, Optional<Integer> timestamp, Optional<String> type) {
        this.contentState = contentState;
        this.dismissalDate = dismissalDate;
        this.androidLiveUpdateEvent = androidLiveUpdateEvent;
        this.name = name;
        this.timestamp = timestamp;
        this.type = type;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Map<String, String>> getContentState() {
        return this.contentState;
    }

    public Optional<Integer> getDismissalDate() {
        return this.dismissalDate;
    }

    public AndroidLiveUpdateEvent getAndroidLiveUpdateEvent() {
        return this.androidLiveUpdateEvent;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidLiveUpdate that = (AndroidLiveUpdate)o;
        return Objects.equals(this.contentState, that.contentState) && Objects.equals(this.dismissalDate, that.dismissalDate) && this.androidLiveUpdateEvent == that.androidLiveUpdateEvent && Objects.equals(this.name, that.name) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentState, this.dismissalDate, this.androidLiveUpdateEvent, this.name, this.timestamp, this.type});
    }

    public String toString() {
        return "AndroidLiveUpdate{contentState=" + this.contentState + ", dismissalDate=" + this.dismissalDate + ", androidLiveUpdateEvent=" + (Object)((Object)this.androidLiveUpdateEvent) + ", name='" + this.name + '\'' + ", timestamp=" + this.timestamp + ", type=" + this.type + '}';
    }

    public static class Builder {
        private ImmutableMap.Builder<String, String> contentState = ImmutableMap.builder();
        private Integer dismissalDate = null;
        private AndroidLiveUpdateEvent androidLiveUpdateEvent = null;
        private String name = null;
        private Integer timestamp = null;
        private String type = null;

        private Builder() {
        }

        public Builder addContentState(String key, String value) {
            this.contentState.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllContentStates(Map<String, String> contentStates) {
            this.contentState.putAll(contentStates);
            return this;
        }

        public Builder setDismissalDate(Integer dismissalDate) {
            this.dismissalDate = dismissalDate;
            return this;
        }

        public Builder setAndroidLiveUpdateEvent(AndroidLiveUpdateEvent androidLiveUpdateEvent) {
            this.androidLiveUpdateEvent = androidLiveUpdateEvent;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTimestamp(Integer timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public AndroidLiveUpdate build() {
            return new AndroidLiveUpdate(Optional.ofNullable(this.contentState.build()), Optional.ofNullable(this.dismissalDate), this.androidLiveUpdateEvent, this.name, Optional.ofNullable(this.timestamp), Optional.ofNullable(this.type));
        }
    }
}

