/*
 * Decompiled with CFR 0.152.
 */
package com.scanii.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.kevinsawicki.http.HttpRequest;
import com.scanii.client.ScaniiException;
import com.scanii.client.ScaniiResult;
import com.scanii.client.ScaniiTarget;
import com.scanii.client.misc.Endpoints;
import com.scanii.client.misc.JSON;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class ScaniiClient {
    private final ScaniiTarget target;
    private final String key;
    private final String secret;
    private final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private final int DEFAULT_READ_TIMEOUT = 60000;

    public ScaniiClient(ScaniiTarget target, String key, String secret) {
        this.target = target;
        this.key = key;
        if (secret != null && secret.length() == 0) {
            secret = null;
        }
        this.secret = secret;
    }

    public ScaniiResult process(Path content) {
        try {
            HttpRequest r = HttpRequest.post((CharSequence)Endpoints.resolve(this.target, "files")).userAgent("scanii-java/v2.0").basic(this.key, this.secret).part("file", content.toFile()).connectTimeout(30000).readTimeout(60000);
            if (r.code() != 201) {
                throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.body()));
            }
            return this.processResponse(r);
        }
        catch (Exception ex) {
            throw new ScaniiException(ex);
        }
    }

    public ScaniiResult processAsync(Path content) {
        try {
            HttpRequest r = HttpRequest.post((CharSequence)Endpoints.resolve(this.target, "files/async")).userAgent("scanii-java/v2.0").basic(this.key, this.secret).part("file", content.toFile()).connectTimeout(30000).readTimeout(60000);
            if (r.code() != 202) {
                throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.body()));
            }
            return this.processResponse(r);
        }
        catch (Exception ex) {
            throw new ScaniiException(ex);
        }
    }

    public ScaniiResult retrieve(String id) {
        try {
            HttpRequest r = HttpRequest.get((CharSequence)Endpoints.resolve(this.target, "files/" + id)).userAgent("scanii-java/v2.0").basic(this.key, this.secret).connectTimeout(30000).readTimeout(60000);
            if (r.code() != 200) {
                throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.message()));
            }
            return this.processResponse(r);
        }
        catch (Exception ex) {
            throw new ScaniiException(ex);
        }
    }

    public ScaniiResult fetch(String location) {
        return this.fetch(location, null);
    }

    public ScaniiResult fetch(String location, String callback) {
        try {
            HttpRequest r = HttpRequest.post((CharSequence)Endpoints.resolve(this.target, "files/fetch")).userAgent("scanii-java/v2.0").basic(this.key, this.secret).form((Object)"location", (Object)location).form((Object)"callback", (Object)callback).connectTimeout(30000).readTimeout(60000);
            if (r.code() != 202) {
                throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.message()));
            }
            return this.processResponse(r);
        }
        catch (Exception ex) {
            throw new ScaniiException(ex);
        }
    }

    public boolean ping() {
        try {
            HttpRequest r = HttpRequest.get((CharSequence)Endpoints.resolve(this.target, "ping")).userAgent("scanii-java/v2.0").basic(this.key, this.secret).connectTimeout(30000).readTimeout(60000);
            if (r.code() != 200) {
                throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.message()));
            }
            return true;
        }
        catch (Exception ex) {
            throw new ScaniiException(ex);
        }
    }

    public ScaniiResult createAuthToken(int timeout, TimeUnit timeoutUnit) {
        HttpRequest r = HttpRequest.post((CharSequence)Endpoints.resolve(this.target, "auth/tokens")).userAgent("scanii-java/v2.0").basic(this.key, this.secret).form((Object)"timeout", (Object)timeoutUnit.toSeconds(timeout)).connectTimeout(30000).readTimeout(60000);
        if (r.code() != 201) {
            throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.message()));
        }
        return this.processResponse(r);
    }

    public boolean deleteAuthToken(String id) {
        HttpRequest r = HttpRequest.delete((CharSequence)Endpoints.resolve(this.target, "auth/tokens/" + id)).userAgent("scanii-java/v2.0").basic(this.key, this.secret).connectTimeout(30000).readTimeout(60000);
        if (r.code() != 204) {
            throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.message()));
        }
        return true;
    }

    public ScaniiResult retrieveAuthToken(String id) {
        HttpRequest r = HttpRequest.get((CharSequence)Endpoints.resolve(this.target, "auth/tokens/" + id)).userAgent("scanii-java/v2.0").basic(this.key, this.secret).connectTimeout(30000).readTimeout(60000);
        if (r.code() != 200) {
            throw new ScaniiException(String.format("Invalid HTTP response from service, code: %s message: %s", r.code(), r.message()));
        }
        return this.processResponse(r);
    }

    private ScaniiResult processResponse(HttpRequest response) {
        try {
            ScaniiResult result = new ScaniiResult();
            result.setResourceLocation(response.header("Location"));
            result.setRequestId(response.header("X-Scanii-Request-Id"));
            result.setHostId(response.header("X-Scanii-Host-Id"));
            JsonNode js = JSON.load(response.body());
            result.setRawResponse(js.toString());
            result.setResourceId(js.get("id").asText());
            if (js.has("findings")) {
                result.setContentType(js.get("content_type").asText());
                result.setContentLength(js.get("content_length").asLong());
                result.setChecksum(js.get("checksum").asText());
                ArrayList<String> findings = new ArrayList<String>();
                Iterator iter = js.get("findings").elements();
                while (iter.hasNext()) {
                    findings.add(((JsonNode)iter.next()).asText());
                }
                result.setFindings(Collections.unmodifiableList(findings));
            }
            if (js.has("message")) {
                result.setMessage(js.get("message").asText());
            }
            if (js.has("expiration_date")) {
                result.setExpirationDate(js.get("expiration_date").asText());
            }
            if (js.has("creation_date")) {
                result.setCreationDate(js.get("creation_date").asText());
            }
            return result;
        }
        catch (Exception ex) {
            throw new ScaniiException("Invalid response from service " + ex.getMessage(), ex);
        }
    }
}

