/*
 * Decompiled with CFR 0.152.
 */
package com.scanii.client.batch;

import com.scanii.client.ScaniiClient;
import com.scanii.client.ScaniiException;
import com.scanii.client.ScaniiResult;
import com.scanii.client.batch.ScaniiResultHandler;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ScaniiBatchClient {
    private static final int MAX_CONCURRENT_REQUESTS = 10 * Runtime.getRuntime().availableProcessors();
    private final Semaphore semaphore;
    private final ExecutorService workers;
    private final ScaniiClient client;
    private final AtomicInteger pending = new AtomicInteger();
    private final AtomicLong completed = new AtomicLong();
    private final AtomicLong failed = new AtomicLong();

    public ScaniiBatchClient(ScaniiClient client) {
        this(client, MAX_CONCURRENT_REQUESTS);
    }

    public ScaniiBatchClient(ScaniiClient client, int maxConcurrentRequests) {
        this.client = client;
        this.semaphore = new Semaphore(maxConcurrentRequests);
        this.workers = Executors.newWorkStealingPool(maxConcurrentRequests);
    }

    public void submit(final Path content, final ScaniiResultHandler handler) {
        try {
            this.semaphore.acquire();
            this.pending.incrementAndGet();
            this.workers.execute(new Runnable(){

                public void run() {
                    String originalThreadName = Thread.currentThread().getName();
                    Thread.currentThread().setName(String.format("ScaniiBatchWorker[%s]", content.getFileName()));
                    try {
                        ScaniiResult result = ScaniiBatchClient.this.client.process(content);
                        handler.handle(result);
                        ScaniiBatchClient.this.completed.incrementAndGet();
                    }
                    finally {
                        Thread.currentThread().setName(originalThreadName);
                        ScaniiBatchClient.this.pending.decrementAndGet();
                    }
                }
            });
        }
        catch (Exception ex) {
            this.failed.incrementAndGet();
            throw new ScaniiException(ex);
        }
        finally {
            this.semaphore.release();
        }
    }

    public boolean hasPending() {
        return this.pending.get() > 0;
    }

    public long getCompletedCount() {
        return this.completed.get();
    }

    public long getFailedCount() {
        return this.failed.get();
    }
}

