/*
 * Decompiled with CFR 0.152.
 */
package com.scanii.client.cli;

import com.scanii.client.ScaniiClient;
import com.scanii.client.ScaniiException;
import com.scanii.client.ScaniiResult;
import com.scanii.client.ScaniiTarget;
import com.scanii.client.batch.ScaniiBatchClient;
import com.scanii.client.batch.ScaniiResultHandler;
import com.scanii.client.misc.Endpoints;
import humanize.Humanize;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class ScaniiCLI {
    public static void main(String[] args) throws IOException, ArgumentParserException, InterruptedException {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"scanii-cli").defaultHelp(true).description("Scanii.com command line interface");
        parser.addArgument(new String[]{"-c", "--credentials"}).help("api credentials to use in the KEY:SECRET format").required(true);
        parser.addArgument(new String[]{"-e", "--endpoint"}).choices((Object[])new String[]{"us1", "eu1", "auto"}).help("api endpoint to be used, see: http://docs.scanii.com/articles/understanding-api-endpoints.html").setDefault((Object)"auto");
        parser.addArgument(new String[]{"path"}).nargs(1).help("path to local content to be processed");
        Namespace ns = null;
        try {
            ns = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        String KEY = ns.getString("credentials").split(":")[0];
        String SECRET = ns.getString("credentials").split(":")[1];
        ScaniiTarget target = ScaniiTarget.v2_0;
        if (ns.getString("endpoint").equals("us1")) {
            target = ScaniiTarget.v2_0_US1;
        } else if (ns.getString("endpoint").equals("eu1")) {
            target = ScaniiTarget.v2_0_EU1;
        }
        System.out.println("scanii-cli starting....");
        System.out.println("using endpoint: " + Endpoints.resolve(target, ""));
        System.out.println("using key: " + KEY);
        System.out.print("verifying connectivity to scanii service...");
        ScaniiClient client = new ScaniiClient(target, KEY, SECRET);
        try {
            client.ping();
        }
        catch (ScaniiException ex) {
            System.out.println("ERROR, please check your credentials...");
            ex.printStackTrace();
            System.exit(1);
        }
        System.out.println("OK");
        final AtomicLong totalFiles = new AtomicLong();
        List paths = ns.getList("path");
        System.out.print("processing file list for path:" + paths.toString() + "...");
        for (String dir : paths) {
            Files.walkFileTree(Paths.get(dir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (!attrs.isDirectory()) {
                        totalFiles.incrementAndGet();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        System.out.println("done");
        System.out.println("processing " + Humanize.formatDecimal((Number)totalFiles.get()) + " files in batch mode");
        final ScaniiBatchClient bclient = new ScaniiBatchClient(client);
        final AtomicLong bytesProcessed = new AtomicLong();
        long startTime = System.nanoTime();
        for (String dir : paths) {
            Files.walkFileTree(Paths.get(dir, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(final Path path, BasicFileAttributes attrs) throws IOException {
                    if (!attrs.isDirectory()) {
                        bclient.submit(path, new ScaniiResultHandler(){

                            public void handle(ScaniiResult result) {
                                bytesProcessed.addAndGet(result.getContentLength());
                                long completed = bclient.getCompletedCount();
                                float total = totalFiles.get();
                                String percentage = Humanize.formatPercent((Number)Float.valueOf((float)completed / total));
                                System.out.println(String.format("\u279d %s | findings: %s completed: %s/%s (%s)", path.toAbsolutePath().toString(), result.getFindings(), Humanize.formatDecimal((Number)completed), Humanize.formatDecimal((Number)Float.valueOf(total)), percentage));
                            }
                        });
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        while (bclient.hasPending()) {
            Thread.sleep(1000L);
        }
        long elapsed = System.nanoTime() - startTime;
        System.out.println(">>");
        System.out.println("run summary:");
        System.out.println(String.format(">> %d files processed in %s", bclient.getCompletedCount(), Humanize.nanoTime((Number)elapsed)));
        System.out.println(String.format(">> throughput: %s/s", Humanize.binaryPrefix((Number)(bytesProcessed.get() / TimeUnit.NANOSECONDS.toSeconds(elapsed)))));
        System.out.println(">>");
    }
}

