/*
 * Decompiled with CFR 0.152.
 */
package com.scanii.client.misc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON {
    private static ObjectMapper mapper = new ObjectMapper();

    public static <T> T load(String js, Class<T> valueType) {
        try {
            return (T)mapper.readValue(js, valueType);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T load(Path file, Class<T> valueType) {
        try {
            return JSON.load(new String(Files.readAllBytes(file)), valueType);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonNode load(Path file) {
        try {
            return mapper.readTree(Files.readAllBytes(file));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonNode load(String js) {
        try {
            return mapper.readTree(js);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String dump(Object o) {
        try {
            return mapper.writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> map(String js) {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)mapper.readValue(js, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectNode object() {
        return mapper.createObjectNode();
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat((DateFormat)new ISO8601DateFormat());
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

