/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.report.itext.style.stylers;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import com.vectorprint.VectorPrintException;
import com.vectorprint.VectorPrintRuntimeException;
import com.vectorprint.configuration.EnhancedMap;
import com.vectorprint.configuration.annotation.SettingsAnnotationProcessor;
import com.vectorprint.configuration.annotation.SettingsAnnotationProcessorImpl;
import com.vectorprint.configuration.parameters.BooleanParameter;
import com.vectorprint.configuration.parameters.Parameter;
import com.vectorprint.configuration.parameters.StringParameter;
import com.vectorprint.report.itext.ImageLoader;
import com.vectorprint.report.itext.LayerManager;
import com.vectorprint.report.itext.style.parameters.FloatParameter;
import com.vectorprint.report.itext.style.stylers.ChartThemeParameter;
import com.vectorprint.report.itext.style.stylers.ChartTypeParameter;
import com.vectorprint.report.itext.style.stylers.DefaultChartThemeBuilder;
import com.vectorprint.report.itext.style.stylers.Image;
import com.vectorprint.report.jfree.ChartBuilder;
import com.vectorprint.report.jfree.ChartThemeBuilder;
import com.vectorprint.report.jfree.ItextChartHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Observable;
import org.jfree.data.general.Dataset;

public class Chart
extends Image<Dataset> {
    public static final String CAT_LABEL = "catLabel";
    public static final String VAL_LABEL = "valLabel";
    public static final String TITLE = "title";
    public static final String VERTICAL = "vertical";
    public static final String LEGEND = "legend";
    public static final String HEIGHT = "height";
    public static final String TYPE = "type";
    public static final String THEMEBUILDER = "themebuilder";
    private static final SettingsAnnotationProcessor SETTINGS_ANNOTATION_PROCESSOR = new SettingsAnnotationProcessorImpl();

    public Chart() {
        this.initParams();
    }

    private void initParams() {
        this.addParameter(new StringParameter(CAT_LABEL, "label for data categories").setDefault((Serializable)((Object)CAT_LABEL)), Chart.class);
        this.addParameter(new StringParameter(TITLE, "label for data categories").setDefault((Serializable)((Object)TITLE)), Chart.class);
        this.addParameter(new StringParameter(VAL_LABEL, "label for data categories").setDefault((Serializable)((Object)VAL_LABEL)), Chart.class);
        this.addParameter((Parameter)new BooleanParameter(VERTICAL, "vertical orientation of chart"), Chart.class);
        this.addParameter(new BooleanParameter(LEGEND, "show legend or not").setDefault((Serializable)Boolean.TRUE), Chart.class);
        this.addParameter(new FloatParameter("width", "width of the chart").setDefault((Serializable)Float.valueOf(50.0f)), Chart.class);
        this.addParameter(new FloatParameter(HEIGHT, "height of the chart").setDefault((Serializable)Float.valueOf(50.0f)), Chart.class);
        this.addParameter((Parameter)new ChartTypeParameter(TYPE, "kind of chart: " + Arrays.asList(ChartBuilder.CHARTTYPE.values())), Chart.class);
        this.addParameter(new ChartThemeParameter(THEMEBUILDER, "classname of the themebuilder to use").setDefault(new DefaultChartThemeBuilder()), Chart.class);
    }

    public Chart(ImageLoader imageLoader, LayerManager layerManager, Document document, PdfWriter writer, EnhancedMap settings) throws VectorPrintException {
        super(imageLoader, layerManager, document, writer, settings);
        this.initParams();
    }

    protected com.itextpdf.text.Image createImage(PdfContentByte canvas, Dataset data, float opacity) throws VectorPrintException, BadElementException {
        ChartBuilder cb = new ChartBuilder(this.getType(), data, this.getTitle(), this.getTitle(), this.getValLabel(), this.isVertical(), this.isLegend(), (ChartThemeBuilder)this.getValue(THEMEBUILDER, ChartThemeBuilder.class), this.getSettings());
        com.itextpdf.text.Image img = ItextChartHelper.getChartImage(cb.getChart(), canvas, this.getWidth(), this.getHeight(), opacity);
        this.applySettings(img);
        return img;
    }

    public ChartBuilder.CHARTTYPE getType() {
        return (ChartBuilder.CHARTTYPE)((Object)this.getValue(TYPE, ChartBuilder.CHARTTYPE.class));
    }

    public void setThemeBuilder(ChartThemeBuilder themeBuilder) {
        this.setValue(THEMEBUILDER, themeBuilder);
    }

    public String getCatLabel() {
        return (String)((Object)this.getValue(CAT_LABEL, String.class));
    }

    public void setCatLabel(String catLabel) {
        this.setValue(CAT_LABEL, (Serializable)((Object)catLabel));
    }

    public String getValLabel() {
        return (String)((Object)this.getValue(VAL_LABEL, String.class));
    }

    public void setValLabel(String valLabel) {
        this.setValue(VAL_LABEL, (Serializable)((Object)valLabel));
    }

    public String getTitle() {
        return (String)((Object)this.getValue(TITLE, String.class));
    }

    public void setTitle(String title) {
        this.setValue(TITLE, (Serializable)((Object)title));
    }

    public boolean isVertical() {
        return (Boolean)this.getValue(VERTICAL, Boolean.class);
    }

    public void setVertical(boolean vertical) {
        this.setValue(VERTICAL, Boolean.valueOf(vertical));
    }

    public boolean isLegend() {
        return (Boolean)this.getValue(LEGEND, Boolean.class);
    }

    public void setLegend(boolean legend) {
        this.setValue(LEGEND, Boolean.valueOf(legend));
    }

    public float getWidth() {
        return ((Float)this.getValue("width", Float.class)).floatValue();
    }

    public void setWidth(float width) {
        this.setValue("width", Float.valueOf(width));
    }

    public float getHeight() {
        return ((Float)this.getValue(HEIGHT, Float.class)).floatValue();
    }

    public void setHeight(float height) {
        this.setValue(HEIGHT, Float.valueOf(height));
    }

    public void update(Observable o, Object arg) {
        Parameter p = (Parameter)o;
        if (ChartThemeBuilder.class.isAssignableFrom(p.getValueClass())) {
            SETTINGS_ANNOTATION_PROCESSOR.initSettings((Object)p.getValue(), this.getSettings());
        }
    }

    public Dataset convert(Object s) {
        if (s instanceof Dataset) {
            return (Dataset)s;
        }
        throw new VectorPrintRuntimeException(String.format("override this method to convert %s (value: %s) to a Dataset", s != null ? s.getClass().getName() : null, String.valueOf(s)));
    }
}

