/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.report.jfree;

import com.vectorprint.VectorPrintException;
import com.vectorprint.configuration.EnhancedMap;
import com.vectorprint.report.jfree.ChartThemeBuilder;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class ChartBuilder {
    private boolean legend = true;
    private boolean tooltips = false;
    private boolean urls = false;
    private boolean vertical = false;
    private JFreeChart chart;
    private String title;
    private String categoryLabel;
    private String valueLabel;
    private EnhancedMap settings;

    public ChartBuilder(CHARTTYPE type, Dataset data, ChartThemeBuilder themeBuilder, EnhancedMap settings) throws VectorPrintException {
        this(type, data, "", "", "", themeBuilder, settings);
    }

    public ChartBuilder(CHARTTYPE type, Dataset data, String title, String categoryLabel, String valueLabel, ChartThemeBuilder themeBuilder, EnhancedMap settings) throws VectorPrintException {
        this(type, data, title, categoryLabel, valueLabel, false, true, themeBuilder, settings);
    }

    public ChartBuilder(CHARTTYPE type, Dataset data, String title, String categoryLabel, String valueLabel, boolean vertical, boolean legend, ChartThemeBuilder themeBuilder, EnhancedMap settings) throws VectorPrintException {
        this.title = title;
        this.categoryLabel = categoryLabel;
        this.valueLabel = valueLabel;
        this.vertical = vertical;
        this.legend = legend;
        if (themeBuilder != null) {
            this.setTheme(themeBuilder.fromSettings(settings));
        }
        this.prepareChart(data, type);
        this.chart.setAntiAlias(true);
    }

    private PlotOrientation getOrientation() {
        return this.vertical ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
    }

    private void prepareChart(Dataset data, CHARTTYPE type) throws VectorPrintException {
        switch (type) {
            case AREA: {
                this.chart = ChartFactory.createAreaChart((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (PlotOrientation)this.getOrientation(), (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            }
            case LINE: {
                if (this.chart == null) {
                    this.chart = ChartFactory.createLineChart((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (PlotOrientation)this.getOrientation(), (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
                }
            }
            case LINE3D: {
                if (this.chart == null) {
                    this.chart = ChartFactory.createLineChart3D((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (PlotOrientation)this.getOrientation(), (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
                }
            }
            case BAR: {
                if (this.chart == null) {
                    this.chart = ChartFactory.createBarChart((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (PlotOrientation)this.getOrientation(), (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
                }
            }
            case BAR3D: {
                if (this.chart == null) {
                    this.chart = ChartFactory.createBarChart3D((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (PlotOrientation)this.getOrientation(), (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
                }
                if (data instanceof CategoryDataset) {
                    CategoryDataset cd = (CategoryDataset)data;
                    this.chart.getCategoryPlot().setDataset(cd);
                    break;
                }
                throw new VectorPrintException("you should use CategoryDataset for this chart");
            }
            case PIE: {
                this.chart = ChartFactory.createPieChart((String)this.title, null, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            }
            case PIE3D: {
                if (this.chart == null) {
                    this.chart = ChartFactory.createPieChart3D((String)this.title, null, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
                }
                if (data instanceof PieDataset) {
                    PieDataset pd = (PieDataset)data;
                    PiePlot pp = (PiePlot)this.chart.getPlot();
                    pp.setDataset(pd);
                    break;
                }
                throw new VectorPrintException("you should use PieDataset for this chart");
            }
            case XYLINE: {
                this.chart = ChartFactory.createXYLineChart((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (PlotOrientation)this.getOrientation(), (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
            }
            case XYAREA: {
                if (this.chart == null) {
                    this.chart = ChartFactory.createXYAreaChart((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (PlotOrientation)this.getOrientation(), (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
                }
                if (data instanceof XYDataset) {
                    XYDataset xy = (XYDataset)data;
                    this.chart.getXYPlot().setDataset(xy);
                    break;
                }
                throw new VectorPrintException("you should use XYDataset for this chart");
            }
            case TIME: {
                this.chart = ChartFactory.createTimeSeriesChart((String)this.title, (String)this.categoryLabel, (String)this.valueLabel, null, (boolean)this.legend, (boolean)this.tooltips, (boolean)this.urls);
                if (data instanceof TimeSeriesCollection) {
                    TimeSeriesCollection xy = (TimeSeriesCollection)data;
                    this.chart.getXYPlot().setDataset((XYDataset)xy);
                    break;
                }
                throw new VectorPrintException("you should use TimeSeriesCollection for this chart");
            }
            default: {
                throw new VectorPrintException("unsupported chart");
            }
        }
        this.chart.setAntiAlias(true);
        this.chart.setTextAntiAlias(true);
    }

    public void setTheme(ChartTheme theme) {
        ChartFactory.setChartTheme((ChartTheme)theme);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void addLineOverlay(CategoryDataset dataset) {
        if (dataset != null && this.chart.getPlot() instanceof CategoryPlot) {
            CategoryPlot plot = this.chart.getCategoryPlot();
            plot.setDataset(1, dataset);
        }
    }

    public ChartFrame show() {
        ChartFrame cf = new ChartFrame(this.chart.getTitle().getText(), this.chart);
        cf.pack();
        cf.setVisible(true);
        return cf;
    }

    public void save(OutputStream img, FILETYPE type, int width, int height) throws IOException {
        switch (type) {
            case JPEG: {
                ChartUtilities.writeChartAsJPEG((OutputStream)img, (JFreeChart)this.chart, (int)width, (int)height);
                break;
            }
            case PNG: {
                ChartUtilities.writeChartAsPNG((OutputStream)img, (JFreeChart)this.chart, (int)width, (int)height);
            }
        }
    }

    public String getCategoryLabel() {
        return this.categoryLabel;
    }

    public void setCategoryLabel(String categoryLabel) {
        this.categoryLabel = categoryLabel;
    }

    public boolean isLegend() {
        return this.legend;
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isTooltips() {
        return this.tooltips;
    }

    public void setTooltips(boolean tooltips) {
        this.tooltips = tooltips;
    }

    public boolean isUrls() {
        return this.urls;
    }

    public void setUrls(boolean urls) {
        this.urls = urls;
    }

    public String getValueLabel() {
        return this.valueLabel;
    }

    public void setValueLabel(String valueLabel) {
        this.valueLabel = valueLabel;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public static enum FILETYPE {
        JPEG,
        PNG;

    }

    public static enum CHARTTYPE {
        AREA,
        LINE,
        LINE3D,
        BAR,
        BAR3D,
        PIE,
        PIE3D,
        XYLINE,
        XYAREA,
        TIME;

    }
}

