/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui;

import com.vectorprint.ClassHelper;
import com.vectorprint.configuration.binding.parameters.ParamBindingHelper;
import com.vectorprint.configuration.binding.parameters.ParamBindingService;
import com.vectorprint.configuration.parameters.Parameter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;

public class ParameterProps<T extends Serializable>
extends SimpleObjectProperty<ParameterProps<T>>
implements Comparable<ParameterProps>,
ChangeListener,
Observer {
    private final Class type;
    private String value;
    private final Parameter<T> p;

    public ParameterProps(Parameter<T> p) {
        this.p = p;
        this.type = ClassHelper.findParameterClass((int)0, p.getClass(), Parameter.class);
        ParamBindingHelper helper = ParamBindingService.getInstance().getFactory().getBindingHelper();
        this.value = helper.serializeValue((Object)helper.getValueToSerialize(p, false));
        this.fireValueChangedEvent();
        p.addObserver((Observer)this);
        this.set(this);
    }

    public String getKey() {
        return this.p.getKey();
    }

    public String getType() {
        return this.type.getName();
    }

    public Class getValueClass() {
        return this.type;
    }

    public String getVal() {
        return this.value;
    }

    public T getRawValue() {
        return (T)this.p.getValue();
    }

    public T getDefault() {
        return (T)this.p.getDefault();
    }

    public void setValue(String value) {
        ParamBindingHelper helper = ParamBindingService.getInstance().getFactory().getBindingHelper();
        if (value != null && !value.isEmpty()) {
            Serializable parseAsParameterValue = ParamBindingService.getInstance().getFactory().getParser((Reader)new StringReader("")).parseAsParameterValue(value, this.p);
            helper.setValueOrDefault(this.p, parseAsParameterValue, false);
        } else {
            helper.setValueOrDefault(this.p, null, false);
        }
    }

    public String getHelp() {
        return this.p.getHelp();
    }

    public String getDeclaringClass() {
        return this.p.getDeclaringClass().getName();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.p.getKey());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterProps other = (ParameterProps)obj;
        return Objects.equals(this.p.getKey(), other.p.getKey());
    }

    @Override
    public int compareTo(ParameterProps o) {
        return this.getKey().compareTo(o.getKey());
    }

    public void changed(ObservableValue observable, Object oldValue, Object newValue) {
        ParamBindingHelper helper = ParamBindingService.getInstance().getFactory().getBindingHelper();
        Object val = newValue;
        if (val instanceof Color) {
            Color c = (Color)val;
            val = new java.awt.Color((int)(c.getRed() * 255.0), (int)(c.getGreen() * 255.0), (int)(c.getBlue() * 255.0));
        }
        if (this.p.getValueClass().isInstance(val)) {
            helper.setValueOrDefault(this.p, (Serializable)val, false);
        } else {
            this.setValue(helper.serializeValue(val));
        }
    }

    public void resetToDefault() {
        this.p.setValue(this.p.getDefault());
        this.fireValueChangedEvent();
    }

    @Override
    public void update(Observable o, Object arg) {
        Parameter p = (Parameter)o;
        ParamBindingHelper helper = ParamBindingService.getInstance().getFactory().getBindingHelper();
        this.value = helper.serializeValue((Object)helper.getValueToSerialize(p, false));
    }
}

