/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui;

import com.vectorprint.VectorPrintRuntimeException;
import com.vectorprint.configuration.EnhancedMap;
import com.vectorprint.configuration.parameters.Parameterizable;
import com.vectorprint.report.itext.style.BaseStyler;
import com.vectorprint.report.itext.style.StylingCondition;
import com.vectorprint.report.itext.style.conditions.AbstractCondition;
import com.vectorprint.report.itext.style.stylers.AbstractStyler;
import com.vectorprint.vectorprintreportgui.text.SearchableTextArea;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;

public class ViewHelper {
    public static Tooltip tip(String text) {
        Tooltip t = new Tooltip(text);
        t.setMaxWidth(400.0);
        t.setAutoHide(false);
        t.setAutoFix(true);
        t.setWrapText(true);
        return t;
    }

    public static String addNewLines(String orig, int linelength) {
        if (orig == null || orig.length() <= linelength) {
            return orig;
        }
        StringBuilder sb = new StringBuilder(orig.length());
        int offset = 0;
        while (offset < orig.length()) {
            int end = offset + linelength >= orig.length() ? orig.length() : offset + linelength;
            sb.append(orig.substring(offset, end)).append(System.getProperty("line.separator"));
            offset = end;
        }
        return sb.toString();
    }

    public static void notify(String buttonText, String title, String details) {
        Dialog dialog = new Dialog();
        dialog.setContentText(ViewHelper.addNewLines(details, 120));
        dialog.setTitle(title);
        dialog.setResizable(true);
        ButtonType bt = new ButtonType(buttonText, ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().add((Object)bt);
        dialog.showAndWait();
    }

    public static String helpFor(Parameterizable p) {
        return p instanceof BaseStyler ? (((BaseStyler)p).creates() ? "creates iText element " : "") + ((BaseStyler)p).getHelp() : ((StylingCondition)p).getHelp();
    }

    public static boolean isStyler(String key, EnhancedMap settings) {
        String[] classes;
        block6: {
            classes = null;
            try {
                classes = settings.getStringProperties(null, new String[]{key});
            }
            catch (VectorPrintRuntimeException e) {
                if (e.getMessage().contains("this does not match requested class")) break block6;
                throw e;
            }
        }
        if (classes == null) {
            return false;
        }
        for (String s : classes) {
            try {
                Class.forName(AbstractStyler.class.getPackage().getName() + "." + s.split("\\(")[0]);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        return true;
    }

    public static boolean isCondition(String key, EnhancedMap settings) {
        String[] classes;
        block6: {
            classes = null;
            try {
                classes = settings.getStringProperties(null, new String[]{key});
            }
            catch (VectorPrintRuntimeException e) {
                if (e.getMessage().contains("this does not match requested class")) break block6;
                throw e;
            }
        }
        if (classes == null) {
            return false;
        }
        for (String s : classes) {
            try {
                Class.forName(AbstractCondition.class.getPackage().getName() + "." + s.split("\\(")[0]);
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
        return true;
    }

    public static boolean isCondition(String key, List<Parameterizable> parameterizables) {
        if (parameterizables == null) {
            return false;
        }
        for (Parameterizable parameterizable : parameterizables) {
            if (!(parameterizable instanceof StylingCondition)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStyler(String key, List<Parameterizable> parameterizables) {
        if (parameterizables == null) {
            return false;
        }
        for (Parameterizable parameterizable : parameterizables) {
            if (!(parameterizable instanceof BaseStyler)) continue;
            return true;
        }
        return false;
    }

    public static String toHex(Color color) {
        int red = (int)(color.getRed() * 255.0);
        int green = (int)(color.getGreen() * 255.0);
        int blue = (int)(color.getBlue() * 255.0);
        return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }

    public static void writeStackTrace(Throwable ex, SearchableTextArea area) {
        StringWriter sw = new StringWriter(1024);
        ex.printStackTrace(new PrintWriter(sw));
        area.getText().clear();
        area.getText().setText(sw.toString());
    }

    public static void toError(Throwable ex, SearchableTextArea area) {
        ViewHelper.writeStackTrace(ex, area);
        ViewHelper.notify("ok (errors tab for details)", "error", ex.getMessage());
    }

    public static FileChooser prepareFC(String title, String filterDescription, String ... filters) {
        FileChooser fc = new FileChooser();
        fc.setTitle(title);
        FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(filterDescription, filters);
        fc.getExtensionFilters().add((Object)extensionFilter);
        return fc;
    }

    private ViewHelper() {
    }
}

