/*
 * Decompiled with CFR 0.152.
 */
package com.vectorprint.vectorprintreportgui.text;

import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class SearchableTextArea
extends AnchorPane {
    @FXML
    private Label searchText;
    @FXML
    private TextArea text;
    @FXML
    private ToggleButton findMode;
    private boolean scroll;

    public SearchableTextArea() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(SearchableTextArea.class.getSimpleName() + ".fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public Label getSearchText() {
        return this.searchText;
    }

    public TextArea getText() {
        return this.text;
    }

    public void setEditable(boolean editable) {
        this.text.editableProperty().set(editable);
    }

    public boolean isEditable() {
        return this.text.editableProperty().get();
    }

    private static boolean supportedInSearch(KeyCode keyCode) {
        return KeyCode.SEMICOLON == keyCode || KeyCode.COLON == keyCode || KeyCode.COMMA == keyCode || KeyCode.EXCLAMATION_MARK == keyCode || KeyCode.EQUALS == keyCode || KeyCode.UNDERSCORE == keyCode || KeyCode.UNDERSCORE == keyCode || KeyCode.PERIOD == keyCode || KeyCode.MINUS == keyCode || KeyCode.BRACELEFT == keyCode || KeyCode.BRACERIGHT == keyCode || KeyCode.OPEN_BRACKET == keyCode || KeyCode.CLOSE_BRACKET == keyCode || KeyCode.ASTERISK == keyCode || KeyCode.AMPERSAND == keyCode || KeyCode.LEFT_PARENTHESIS == keyCode || KeyCode.RIGHT_PARENTHESIS == keyCode || KeyCode.PLUS == keyCode || KeyCode.QUOTE == keyCode || KeyCode.QUOTEDBL == keyCode || KeyCode.BACK_QUOTE == keyCode || KeyCode.BACK_SLASH == keyCode || KeyCode.SLASH == keyCode || KeyCode.DOLLAR == keyCode || KeyCode.EURO_SIGN == keyCode || KeyCode.POUND == keyCode || KeyCode.GREATER == keyCode || KeyCode.LESS == keyCode || KeyCode.STAR == keyCode;
    }

    private void searchTxt(KeyEvent event) {
        KeyCode kc = event.getCode();
        this.scroll = false;
        this.searchText.setTextFill((Paint)Color.BLACK);
        String s = this.searchText.getText();
        boolean again = false;
        if (kc.isLetterKey() || kc.isDigitKey() || kc.isWhitespaceKey() || SearchableTextArea.supportedInSearch(kc)) {
            s = s + event.getText();
        } else {
            switch (kc) {
                case BACK_SPACE: {
                    if (s.length() > 0) {
                        s = s.substring(0, s.length() - 1);
                    }
                }
                case F3: {
                    again = true;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.searchText.setText(s);
        if (s.length() == 0) {
            return;
        }
        this.searchText.setTextFill((Paint)(this.searchArea(s, again) ? Color.GREEN : Color.RED));
    }

    public final boolean searchArea(String s, boolean again) {
        boolean noBackspace;
        String contents = this.text.getText();
        int pos = again ? this.text.getCaretPosition() : this.text.getCaretPosition() - s.length() - 1;
        boolean bl = noBackspace = this.text.getSelection().getLength() < s.length();
        if (contents.indexOf(s, pos) != -1) {
            this.text.selectRange(contents.indexOf(s, pos), contents.indexOf(s, pos) + s.length());
            if (noBackspace && this.text.getCaretPosition() != pos + s.length() + 2) {
                this.scroll = true;
            }
        } else if (contents.contains(s)) {
            this.text.selectRange(contents.indexOf(s), contents.indexOf(s) + s.length());
        } else {
            return false;
        }
        return true;
    }

    @FXML
    private void scroll(KeyEvent event) {
        if (this.scroll) {
            this.text.setScrollTop(this.text.getScrollTop() + 20.0);
        }
    }

    @FXML
    private void ignore(KeyEvent event) {
        if (this.findMode.isSelected()) {
            event.consume();
        }
    }

    @FXML
    private void searchOrEdit(KeyEvent event) {
        if (this.findMode.isSelected()) {
            event.consume();
        }
        if (event.isControlDown() && KeyCode.F == event.getCode()) {
            this.setFindMode(!this.isFindMode());
        } else if (KeyCode.ESCAPE == event.getCode()) {
            this.setFindMode(false);
        } else if (this.isFindMode()) {
            this.searchTxt(event);
        }
    }

    @FXML
    private void toggleMode() {
        this.searchStyle();
        this.text.requestFocus();
    }

    private void searchStyle() {
        if (this.findMode.isSelected()) {
            this.text.getStyleClass().add((Object)"searching");
        } else {
            this.text.getStyleClass().remove((Object)"searching");
        }
    }

    public boolean isFindMode() {
        return !this.text.isEditable() || this.findMode.isSelected();
    }

    public void setFindMode(boolean findMode) {
        this.findMode.setSelected(findMode);
        if (!findMode) {
            this.searchText.setText("");
        }
        this.searchStyle();
    }
}

